/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepFind;
import com.tonicsystems.jarjar.MainProcessor;
import com.tonicsystems.jarjar.MainUtil;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.RulesFileParser;
import com.tonicsystems.jarjar.StringDumper;
import com.tonicsystems.jarjar.TextDepHandler;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import com.tonicsystems.jarjar.ext_util.StandaloneJarProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;

public class Main {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String HELP;
    private boolean verbose;
    private List patterns;
    private int level = 0;

    private static String readIntoString(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        String line = null;
        while ((line = r.readLine()) != null) {
            sb.append(line).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        MainUtil.runMain(new Main(), args, "help");
    }

    public void help() {
        System.err.print(HELP);
    }

    public void strings(String cp) throws IOException {
        if (cp == null) {
            throw new IllegalArgumentException("cp is required");
        }
        new StringDumper().run(cp, new PrintWriter(System.out));
    }

    public void find(String level, String cp1, String cp2) throws IOException {
        int levelFlag;
        if (level == null || cp1 == null) {
            throw new IllegalArgumentException("level and cp1 are required");
        }
        if (cp2 == null) {
            cp2 = cp1;
        }
        if ("class".equals(level)) {
            levelFlag = 0;
        } else if ("jar".equals(level)) {
            levelFlag = 1;
        } else {
            throw new IllegalArgumentException("unknown level " + level);
        }
        PrintWriter w = new PrintWriter(System.out);
        TextDepHandler handler = new TextDepHandler(w, levelFlag);
        new DepFind().run(cp1, cp2, handler);
        w.flush();
    }

    public void process(File rulesFile, File inJar, File outJar) throws IOException {
        if (rulesFile == null || inJar == null || outJar == null) {
            throw new IllegalArgumentException("rulesFile, inJar, and outJar are required");
        }
        List<PatternElement> rules = RulesFileParser.parse(rulesFile);
        boolean verbose = Boolean.getBoolean("verbose");
        boolean skipManifest = Boolean.getBoolean("skipManifest");
        MainProcessor proc = new MainProcessor(rules, verbose, skipManifest);
        StandaloneJarProcessor.run(inJar, outJar, proc);
        proc.strip(outJar);
    }

    static {
        try {
            HELP = Main.readIntoString(Main.class.getResourceAsStream("help.txt"));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

