# -*- coding: binary -*-

module Msf
  module Exploit::Remote::SMB::Server
    module Share
      module Command
        module Close

          # Handles an SMB_COM_CLOSE command, used by the client to close an instance
          # of an object associated with a valid FID.
          #
          # @param c [Socket] The client sending the request.
          # @param buff [String] The data including the client request.
          # @return [Integer] The number of bytes returned to the client as response.
          def smb_cmd_close(c, buff)
            send_close_res(c)
          end

          # Builds and sends an SMB_COM_CLOSE response.
          #
          # @param c [Socket] The client to answer.
          # @return [Integer] The number of bytes returned to the client as response.
          def send_close_res(c)
            pkt = CONST::SMB_CLOSE_RES_PKT.make_struct
            smb_set_defaults(c, pkt)

            pkt['Payload']['SMB'].v['Command'] = CONST::SMB_COM_CLOSE
            pkt['Payload']['SMB'].v['Flags1'] = FLAGS
            pkt['Payload']['SMB'].v['Flags2'] = FLAGS2
            pkt['Payload']['SMB'].v['WordCount'] = CONST::SMB_CLOSE_RES_WORD_COUNT

            c.put(pkt.to_s)
          end
        end
      end
    end
  end
end
