/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Content;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URL;

final class SubSourceImpl
extends Content {
    private final Source base;
    private final int baseIndex;
    private final int subLength;

    static SubSourceImpl create(Source base, int baseIndex, int length) {
        if (baseIndex < 0 || length < 0 || baseIndex + length > base.getLength()) {
            throw new IllegalArgumentException("text positions out of range");
        }
        return new SubSourceImpl(base, baseIndex, length);
    }

    private SubSourceImpl(Source base, int baseIndex, int length) {
        this.base = base;
        this.baseIndex = baseIndex;
        this.subLength = length;
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public String getShortName() {
        return this.base.getShortName();
    }

    @Override
    public String getPath() {
        return this.base.getPath();
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    URI getURI() {
        return this.base.getURI();
    }

    @Override
    public Reader getReader() {
        assert (false);
        return null;
    }

    @Override
    public String getCode() {
        return this.base.getCode(this.baseIndex, this.subLength);
    }

    @Override
    String findMimeType() throws IOException {
        return this.base.getMimeType();
    }

    @Override
    Object getHashKey() {
        return this.base;
    }
}

