#ifndef _ELM_CHECK_EO_LEGACY_H_
#define _ELM_CHECK_EO_LEGACY_H_

#ifndef _ELM_CHECK_EO_CLASS_TYPE
#define _ELM_CHECK_EO_CLASS_TYPE

typedef Eo Elm_Check;

#endif

#ifndef _ELM_CHECK_EO_TYPES
#define _ELM_CHECK_EO_TYPES


#endif
/**
 * @brief Check widget
 *
 * The check widget allows for toggling a value between true and false. Check
 * objects are a lot like radio objects in layout and functionality, except
 * they do not work as a group, but independently, and only toggle the value of
 * a boolean between false and true.
 *
 * @ingroup Elm_Check
 */

/**
 * @brief The on/off state of the check object.
 *
 * @param[in] value @c true if the check object is selected, @c false otherwise
 *
 * @ingroup Elm_Check
 */
EAPI void elm_check_selected_set(Elm_Check *obj, Eina_Bool value);

/**
 * @brief The on/off state of the check object.
 *
 * @return @c true if the check object is selected, @c false otherwise
 *
 * @ingroup Elm_Check
 */
EAPI Eina_Bool elm_check_selected_get(const Elm_Check *obj);

#endif
