-- EFL LuaJIT bindings: elm_datetime.eo (class Elm.Datetime)
-- For use with Elua; automatically generated, do not modify

local cutil = require("cutil")
local util  = require("util")
local ffi   = require("ffi")
local eo    = require("eo")

local M, __lib = ...

local __class
local __body

local init = function()
    __class = __lib.elm_datetime_class_get()
    eo.class_register("Elm_Datetime", {"Elm_Layout"}, nil, __body, __class)
end

cutil.init_module(init, function() end)

ffi.cdef [[
    const Eo_Class *elm_datetime_class_get(void);
    void elm_obj_datetime_format_set(const char * fmt);
    const char *elm_obj_datetime_format_get(void);
    void elm_obj_datetime_field_limit_set(Elm_Datetime_Field_Type fieldtype, int min, int max);
    void elm_obj_datetime_field_limit_get(Elm_Datetime_Field_Type fieldtype, int *min, int *max);
    Eina_Bool elm_obj_datetime_value_min_set(const Efl_Time * mintime);
    Eina_Bool elm_obj_datetime_value_min_get(Efl_Time *mintime);
    Eina_Bool elm_obj_datetime_value_set(const Efl_Time * newtime);
    Eina_Bool elm_obj_datetime_value_get(Efl_Time *currtime);
    void elm_obj_datetime_field_visible_set(Elm_Datetime_Field_Type fieldtype, Eina_Bool visible);
    Eina_Bool elm_obj_datetime_field_visible_get(Elm_Datetime_Field_Type fieldtype);
    Eina_Bool elm_obj_datetime_value_max_set(const Efl_Time * maxtime);
    Eina_Bool elm_obj_datetime_value_max_get(Efl_Time *maxtime);
    extern const Eo_Event_Description _ELM_DATETIME_EVENT_CHANGED;
]]

__body = {
    __eo_ctor = function(self, __func)
        if __func then __func() end
    end,

    format_set = function(self, fmt)
        eo.__do_start(self, __class)
        __lib.elm_obj_datetime_format_set(fmt)
        eo.__do_end()
    end,

    format_get = function(self)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_datetime_format_get()
        eo.__do_end()
        return v
    end,

    field_limit_set = function(self, fieldtype, min, max)
        eo.__do_start(self, __class)
        __lib.elm_obj_datetime_field_limit_set(fieldtype, min, max)
        eo.__do_end()
    end,

    field_limit_get = function(self, fieldtype)
        eo.__do_start(self, __class)
        local min = ffi.new("int[1]")
        local max = ffi.new("int[1]")
        __lib.elm_obj_datetime_field_limit_get(fieldtype, min, max)
        eo.__do_end()
        return tonumber(min[0]), tonumber(max[0])
    end,

    value_min_set = function(self, mintime)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_datetime_value_min_set(mintime)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    value_min_get = function(self, mintime)
        eo.__do_start(self, __class)
        local mintime = ffi.new("Efl_Time[1]")
        local v = __lib.elm_obj_datetime_value_min_get(mintime)
        eo.__do_end()
        return ((v) ~= 0), mintime[0]
    end,

    value_set = function(self, newtime)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_datetime_value_set(newtime)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    value_get = function(self, currtime)
        eo.__do_start(self, __class)
        local currtime = ffi.new("Efl_Time[1]")
        local v = __lib.elm_obj_datetime_value_get(currtime)
        eo.__do_end()
        return ((v) ~= 0), currtime[0]
    end,

    field_visible_set = function(self, fieldtype, visible)
        eo.__do_start(self, __class)
        __lib.elm_obj_datetime_field_visible_set(fieldtype, visible)
        eo.__do_end()
    end,

    field_visible_get = function(self, fieldtype)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_datetime_field_visible_get(fieldtype)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    value_max_set = function(self, maxtime)
        eo.__do_start(self, __class)
        local v = __lib.elm_obj_datetime_value_max_set(maxtime)
        eo.__do_end()
        return ((v) ~= 0)
    end,

    value_max_get = function(self, maxtime)
        eo.__do_start(self, __class)
        local maxtime = ffi.new("Efl_Time[1]")
        local v = __lib.elm_obj_datetime_value_max_get(maxtime)
        eo.__do_end()
        return ((v) ~= 0), maxtime[0]
    end,

    __events = {
        ["changed"] = __lib._ELM_DATETIME_EVENT_CHANGED
    },

    __properties = {
        ["format"] = { 0, 0, 1, 1, true, true }
    }
}

M.Datetime = function(parent, ...)
    return eo.__ctor_common(__class, parent, eo.class_get("Elm_Datetime").__eo_ctor,
                            1, ...)
end

return M
