/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.dns;

import com.sun.jndi.url.dns.dnsURLContext;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public class dnsURLContextFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object urlInfo, Name name, Context nameCtx, Hashtable<?, ?> env) throws NamingException {
        if (urlInfo == null) {
            return new dnsURLContext(env);
        }
        if (urlInfo instanceof String) {
            return dnsURLContextFactory.getUsingURL((String)urlInfo, env);
        }
        if (urlInfo instanceof String[]) {
            return dnsURLContextFactory.getUsingURLs((String[])urlInfo, env);
        }
        throw new ConfigurationException("dnsURLContextFactory.getObjectInstance: argument must be a DNS URL String or an array of them");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getUsingURL(String url, Hashtable env) throws NamingException {
        try (dnsURLContext urlCtx = new dnsURLContext(env);){
            Object object = urlCtx.lookup(url);
            return object;
        }
    }

    private static Object getUsingURLs(String[] urls, Hashtable env) throws NamingException {
        if (urls.length == 0) {
            throw new ConfigurationException("dnsURLContextFactory: empty URL array");
        }
        try (dnsURLContext urlCtx = new dnsURLContext(env);){
            NamingException ne = null;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    Object object = urlCtx.lookup(urls[i]);
                    return object;
                }
                catch (NamingException e) {
                    ne = e;
                    continue;
                }
            }
            throw ne;
        }
    }
}

