/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.hsqldb.Result;
import org.hsqldb.Types;
import org.hsqldb.jdbc.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class jdbcParameterMetaData
implements ParameterMetaData {
    Result.ResultMetaData rmd;
    int[] types;
    int[] modes;
    boolean[] isIdentity;
    int[] nullability;
    String[] classNames;
    int parameterCount;

    jdbcParameterMetaData(Result result) throws SQLException {
        if (result == null) {
            this.parameterCount = 0;
            return;
        }
        this.rmd = result.metaData;
        this.types = this.rmd.colTypes;
        this.parameterCount = this.types.length;
        this.nullability = this.rmd.colNullable;
        this.isIdentity = this.rmd.isIdentity;
        this.classNames = this.rmd.classNames;
        this.modes = this.rmd.paramMode;
    }

    void checkRange(int n) throws SQLException {
        if (n < 1 || n > this.parameterCount) {
            String string = n + " is out of range";
            throw Util.sqlException(62, string);
        }
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.checkRange(n);
        return this.classNames[--n];
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.checkRange(n);
        return this.modes[--n];
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkRange(n);
        int n2 = this.types[--n];
        return n2 == 100 ? 12 : n2;
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkRange(n);
        return Types.getTypeName(this.types[--n]);
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkRange(n);
        return Types.getPrecision(this.types[--n]);
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkRange(n);
        return 0;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkRange(n);
        return this.nullability[--n];
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkRange(n);
        Boolean bl = Types.isUnsignedAttribute(this.types[--n]);
        return bl != null && bl == false && !this.isIdentity[n];
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n = this.getParameterCount();
        if (n == 0) {
            stringBuffer.append("[parameterCount=0]");
            return stringBuffer.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuffer.append('[');
        int n2 = methodArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\n');
            stringBuffer.append("    parameter_");
            stringBuffer.append(i + 1);
            stringBuffer.append('=');
            stringBuffer.append('[');
            for (int j = 0; j < n2; ++j) {
                Method method = methodArray[j];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuffer.append(method.getName());
                stringBuffer.append('=');
                stringBuffer.append(method.invoke((Object)this, new Integer(i + 1)));
                if (j + 1 >= n2) continue;
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
            if (i + 1 >= n) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append('\n');
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

