%%
%% This is file `tudscrdoc.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% tudscr-version.dtx  (with options: `class,doc')
%% tudscr-doc.dtx  (with options: `class,doc')
%% tudscr-manual.dtx  (with options: `class,doc')
%% tudscr-misc.dtx  (with options: `class,doc,xindy')
%% 
%% ============================================================================
%% 
%%  TUD-Script
%%  Copyright (c) Falk Hanisch <tudscr@gmail.com>, 2012-2016
%% 
%% ============================================================================
%% 
%%  This work may be distributed and/or modified under the conditions of the
%%  LaTeX Project Public License, version 1.3c of the license. The latest
%%  version of this license is in http://www.latex-project.org/lppl.txt and
%%  version 1.3c or later is part of all distributions of LaTeX 2005/12/01
%%  or later and of this work. This work has the LPPL maintenance status
%%  "author-maintained". The current maintainer and author of this work
%%  is Falk Hanisch.
%% 
%% ----------------------------------------------------------------------------
%% 
%%  Dieses Werk darf nach den Bedingungen der LaTeX Project Public Lizenz
%%  in der Version 1.3c, verteilt und/oder veraendert werden. Die aktuelle
%%  Version dieser Lizenz ist http://www.latex-project.org/lppl.txt und
%%  Version 1.3c oder spaeter ist Teil aller Verteilungen von LaTeX 2005/12/01
%%  oder spaeter und dieses Werks. Dieses Werk hat den LPPL-Verwaltungs-Status
%%  "author-maintained", wird somit allein durch den Autor verwaltet. Der
%%  aktuelle Verwalter und Autor dieses Werkes ist Falk Hanisch.
%% 
%% ============================================================================
%% 
%%% From File: tudscr-version.dtx
\begingroup
  \catcode`\@11\relax
  \ifx\TUD@Version\undefined
    \newcommand*\TUD@Version@Check[1]{%
      \gdef\TUD@Version{#1}%
      \gdef\TUDScriptVersion{#1}%
      \def\@tempb##1 v##2 ##3\relax##4\relax{\gdef\TUDScriptVersionNumber{##2}}%
      \edef\@tempa{\TUD@Version}%
      \expandafter\@tempb\@tempa\relax? ? \relax\relax%
      \gdef\TUD@Version@KOMA{3.17}%
    }
  \else
    \newcommand*\TUD@Version@Check[1]{%
      \def\@tempa{#1}%
      \ifx\TUD@Version\@tempa\else%
        \@latex@warning@no@line{%
          \noexpand\TUD@Version\space is `\TUD@Version',\MessageBreak%
          but `#1' was expected!\MessageBreak%
          You should not use classes, packages or files from\MessageBreak%
          different TUD-Script-Bundle versions%
        }%
      \fi%
    }
  \fi
  \TUD@Version@Check{2016/10/12 v2.05f TUD-Script}
\endgroup
\NeedsTeXFormat{LaTeX2e}
\providecommand*\tudscrmail{tudscr@gmail.com}
\newcommand*\TUD@ProvidesClass[3]{%
  \ProvidesClass{#1}[%
  2016/10/12 v2.05f TUD-Script
    ^^J#3 (#2)%
  ]%
  \newcommand*\TUD@Class@KOMA{#2}%
  \@ifundefined{TUD@Class@Parent}{%
    \newcommand*\TUD@Class@Name{#1}%
    \TUD@Class@Info%
  }{}%
}
\providecommand*\TUD@Class@Info{%
  \typeout{+---------------------------------------------------------------}%
  \typeout{| The Corporate Design of Technische Universitaet Dresden}%
  \typeout{| Class: \TUD@Class@Name}%
  \typeout{| Version: \TUD@Version}%
  \typeout{| Author: Falk Hanisch (\tudscrmail)}%
  \typeout{| Forum: http://latex.wcms-file3.tu-dresden.de/phpBB3/}%
  \typeout{+---------------------------------------------------------------}%
}
\TUD@ProvidesClass{tudscrdoc}{scrartcl}{source code documentation class}
\edef\TUDScriptClassName{\TUD@Class@Name}
\providecommand*\TUDClassName{\TUDScriptClassName}
\@ifundefined{TUDScript}{%
  \DeclareRobustCommand\TUDScript{%
    \ifdin{TUD-SCRIPT}{%
      \textsf{T\kern.05em U\kern.05em D\kern.1em-\kern.1em Script}%
    }\csname xspace\endcsname%
  }%
}{}
%%% From File: tudscr-doc.dtx
\RequirePackage{scrbase}[2013/12/19]%
\newcommand*\saved@maketitle{}%
\PassOptionsToClass{toc=left}{scrartcl}%
\AfterClass{scrartcl}{\let\saved@maketitle\@maketitle}%
\AfterClass{ltxdoc}{%
  \let\@maketitle\saved@maketitle%
  \codeline@indexfalse%
}%
\AfterPackage{inputenc}{\RequirePackage{csquotes}[2011/10/22]}%
\newcommand*\sd@saved@LoadClass{}
\let\sd@saved@LoadClass=\LoadClass
\renewcommand*\LoadClass[2][]{%
  \begingroup
    \edef\@tempc{#2}\def\@tempb{article}%
    \ifx\@tempc\@tempb
      \let\LoadClass\sd@saved@LoadClass
      \def\@tempc{scrartcl}%
    \fi
    \edef\@tempc{%
      \noexpand\endgroup\noexpand\sd@saved@LoadClass[{#1}]{\@tempc}}%
  \@tempc
}
\newcommand*\sd@saved@PassOptionsToClass{}
\let\sd@saved@PassOptionsToClass=\PassOptionsToClass
\renewcommand*\PassOptionsToClass[2]{%
  \begingroup
    \edef\@tempc{#2}\def\@tempb{article}%
    \ifx\@tempc\@tempb
      \def\@tempc{scrartcl}%
    \fi
    \edef\@tempc{%
      \noexpand\endgroup\noexpand\sd@saved@PassOptionsToClass{#1}{%
        \@tempc}}%
  \@tempc
}
\LoadClassWithOptions{ltxdoc}
\setcounter{IndexColumns}{2}
\DeclareOption{final}{\let\tudfinalflag\relax}
\DeclareOption{texindy}{\let\tudxdyflag\relax}
\DeclareOption{xindy}{\let\tudxdyflag\relax}
\DeclareOption{xdy}{\let\tudxdyflag\relax}
\ProcessOptions\relax
\setlength\topmargin{-1in}
\setlength\headheight{0pt}
\setlength\headsep{30pt}
\setlength\footskip{1.5\headsep}
\setlength\textheight{\dimexpr\paperheight-2.5\headsep-\footskip\relax}
\setlength\marginparwidth{150pt}
\setlength\marginparsep{0pt}
\setlength\oddsidemargin{\dimexpr\marginparwidth+\marginparsep-1in\relax}
\setlength\textwidth{%
  \dimexpr\paperwidth-1in-\oddsidemargin-.5\headsep\relax%
}
\RequirePackage{tudscrbase}[\TUD@Version]
\RequirePackage{dox}[2010/12/16]
\@ifpackagelater{dox}{2010/12/17}{%
  \ClassWarning{\TUD@Class@Name}{%
    Package `dox' was updated so some patches\MessageBreak%
    are maybe outdated
  }%
}{}%
\CheckCommand\m@cro@[2]{%
  \endgroup \topsep\MacroTopsep \trivlist
  \edef\saved@macroname{\string#2}%
  #1
    \let\saved@indexname\saved@macroname
  \else
    \edef\saved@indexname{\expandafter\@gobble\string#2}%
  \fi
  \def\makelabel##1{\llap{##1}}%
  \if@inlabel
    \let\@tempa\@empty \count@\macro@cnt
    \loop \ifnum\count@>\z@
      \edef\@tempa{\@tempa\hbox{\strut}}\advance\count@\m@ne \repeat
    \edef\makelabel##1{\llap{\vtop to\baselineskip
                               {\@tempa\hbox{##1}\vss}}}%
    \advance \macro@cnt \@ne
  \else  \macro@cnt\@ne  \fi
  \edef\@tempa{\noexpand\item[%
     #1%
       \noexpand\PrintMacroName
     \else
       \noexpand\PrintEnvName
     \fi
     {\string#2}]}%
  \@tempa
  \global\advance\c@CodelineNo\@ne
   #1%
      \SpecialMainIndex{#2}\nobreak
      \DoNotIndex{#2}%
   \else
      \SpecialMainEnvIndex{#2}\nobreak
   \fi
  \global\advance\c@CodelineNo\m@ne
  \ignorespaces
}
\CheckCommand*\changes@[3]{%
  \protected@edef\@tempa{%
    \noexpand\glossary{%
      #1\levelchar
      \ifx\saved@macroname\@empty
        \space
        \actualchar
        \generalname
      \else
        \saved@indexname
        \actualchar
        \string\verb\quotechar*%
        \verbatimchar\saved@macroname
        \verbatimchar
      \fi
      :\levelchar #3%
    }%
  }%
  \@tempa\endgroup\@esphack%
}
\ifdefined\tudxdyflag%
  \renewcommand*\changes@[3]{%
    \@tempswatrue%
    \ifblank{#1}{\@tempswafalse}{}%
    \ifblank{#3}{\@tempswafalse}{}%
    \if@tempswa%
      \protected@edef\@tempa{%
        \noexpand\glossary{%
          #1\levelchar%
          \ifx\saved@macroname\@empty%
            \generalname%
          \else%
            \implementationname%
          \fi%
          \levelchar
          \ifx\saved@macroname\@empty\else%
            \saved@indexname
            \ifx\saved@idxtype\@empty\else%
              \space\saved@idxtype
            \fi%
            \actualchar
            \string\verb\quotechar*%
            \verbatimchar\saved@macroname
            \verbatimchar%
            \ifx\saved@idxtype\@empty\else%
              \space(\saved@idxtype)%
            \fi%
            :\levelchar
          \fi
          #2 #3%
          \actualchar%
          #3% (#2)%
        }%
      }%
    \else%
      \let\@tempa\relax%
    \fi%
    \@tempa\endgroup\@esphack%
  }%
\else%
  \renewcommand*\changes@[3]{%
    \protected@edef\@tempa{%
      \noexpand\glossary{%
        #1\levelchar
        \ifx\saved@macroname\@empty
          \quotechar!
          \actualchar
          \generalname
        \else
          \saved@indexname
          \actualchar
          \string\verb\quotechar*%
          \verbatimchar\saved@macroname
          \verbatimchar
        \fi
        :\levelchar #3%
      }%
    }%
    \@tempa\endgroup\@esphack%
  }%
\fi%
\CheckCommand*\@wrglossary[1]{%
  \protected@write\@glossaryfile{}%
  {\string\glossaryentry{#1}{\thepage}}%
  \endgroup
  \@esphack%
}
\def\filesep{?-}
\def\@wrglossary#1{%
  \ifx\special@index\index%
    \@tempswafalse%
  \else%
    \@tempswatrue%
  \fi%
  \ifx\saved@macroname\@empty%
    \@tempswafalse%
  \fi%
  \if@tempswa%
    \global\advance\c@CodelineNo\@ne
    \protected@write\@glossaryfile{}{%
      \string\glossaryentry{#1}{\filesep\number\c@CodelineNo}%
    }
    \global\advance\c@CodelineNo\m@ne
  \else%
    \protected@write\@glossaryfile{}{\string\glossaryentry{#1}{\thepage}}
  \fi%
  \endgroup
  \@esphack%
}
\renewcommand*\generalname{Allgemein}
\newcommand*\implementationname{Implementierung}
\newcommand*\hypersourcedef[1]{}
\newcommand*\hypersource@def{}
\newcommand*\hypersourceref[1]{#1}
\newcommand*\hypersource@ref[2][]{}
\PassOptionsToPackage{hyperindex=false}{hyperref}
\AfterPackage{hyperref}{%
  \renewcommand*\hypersourcedef[1]{%
    \ifstr{#1}{\hypersource@def}{}{%
      \Hy@raisedlink{\hyperdef{}{source:#1}{}}%
      \xdef\hypersource@def{#1}%
    }%
  }%
  \renewcommand*\hypersourceref[1]{\hypersource@ref{#1}}%
  \renewcommand*\main[1]{\hypersource@ref[\underline]{#1}}%
  \renewcommand*\hypersource@ref[2][\@firstofone]{%
    \begingroup%
      \def\@tempa##1-##2\relax{%
        \IfArgIsEmpty{##2}{%
          \hyperlink{page.\@tempc}{#1{\@tempc}}%
        }{%
          \hyperref{}{}{source:\@tempc}{#1{\@tempc}}%
        }%
      }%
      \def\@tempb##1{%
        \def\@tempc{##1}%
        \expandafter\@tempa##1-\relax%
      }%
      \forcsvlist\@tempb{#2}%
    \endgroup%
  }%
}
\CheckCommand*\@doxcreatespecialmainindex[3]{%
  \expandafter\def\csname SpecialMain#1Index\endcsname##1{%
    \@bsphack%
    \special@index{##1\actualchar{\string\ttfamily\space##1} (#2)
      \encapchar main}%
    \special@index{#3:\levelchar##1\actualchar{\string\ttfamily\space##1}
      \encapchar main}%
    \@esphack%
  }%
}
\patchcmd{\@doxcreatespecialmainindex}{\actualchar}{%
  \space(#2)\actualchar%
}{}{\tud@patch@wrn{@doxcreatespecialmainindex}}
\patchcmd{\@doxcreatespecialmainindex}{\@esphack}{%
  \@esphack\hypersourcedef{\filesep\number\c@CodelineNo}%
}{}{\tud@patch@wrn{@doxcreatespecialmainindex}}
\CheckCommand*\@doxcreatespecialmainmacrolikeindex[3]{%
  \expandafter\def\csname SpecialMain#1Index\endcsname##1{%
    \@SpecialIndexHelper@##1\@nil
    \@bsphack%
    \special@index{\@gtempa\actualchar
      \string\verb\quotechar*\verbatimchar\bslash\@gtempa\verbatimchar
      \space(#2)\encapchar main}%
    \special@index{#3:\levelchar\@gtempa\actualchar%
      \string\verb\quotechar*\verbatimchar\bslash\@gtempa\verbatimchar
      \encapchar main}%
    \@esphack%
  }%
}
\patchcmd{\@doxcreatespecialmainmacrolikeindex}{\actualchar}{%
  \space(#2)\actualchar%
}{}{\tud@patch@wrn{@doxcreatespecialmainmacrolikeindex}}
\patchcmd{\@doxcreatespecialmainmacrolikeindex}{\@esphack}{%
  \@esphack\hypersourcedef{\filesep\number\c@CodelineNo}%
}{}{\tud@patch@wrn{@doxcreatespecialmainmacrolikeindex}}
\CheckCommand*\@doxcreatespecialindex[3]{%
  \expandafter\def\csname Special#1Index\endcsname##1{%
    \@bsphack%
    \index{##1\actualchar{\protect\ttfamily##1} (#2)\encapchar usage}%
    \index{#3:\levelchar##1\actualchar{\protect\ttfamily##1}
      \encapchar usage}%
    \@esphack%
  }%
}
\patchcmd{\@doxcreatespecialindex}{\actualchar}{%
  \space(#2)\actualchar%
}{}{\tud@patch@wrn{@doxcreatespecialindex}}
\CheckCommand*\@doxcreatespecialmacrolikeindex[3]{%
  \expandafter\def\csname Special#1Index\endcsname##1{%
    \@SpecialIndexHelper@##1\@nil
    \@bsphack%
    \index{\@gtempa\actualchar
      \string\verb\quotechar*\verbatimchar\bslash\@gtempa\verbatimchar
      \space(#2)\encapchar usage}%
    \index{#3:\levelchar\@gtempa\actualchar
      \string\verb\quotechar*\verbatimchar\bslash\@gtempa\verbatimchar
      \encapchar usage}%
    \@esphack%
  }%
}
\patchcmd{\@doxcreatespecialmacrolikeindex}{\actualchar}{%
  \space(#2)\actualchar%
}{}{\tud@patch@wrn{@doxcreatespecialmacrolikeindex}}
\CheckCommand\doxitem[4][]{%
  \@nameuse{dox@macrolike\dox@macrolikedefault}%
  \def\dox@idxtype{#3}%
  \setkeys{dox}{#1}
  \@ifundefined{Print#2Name}{%
    \ifdox@macrolike
      \expandafter\def\csname Print#2Name\endcsname##1{%
        \strut\MacroFont\string ##1\ }
    \else
      \expandafter\def\csname Print#2Name\endcsname##1{%
        \strut\MacroFont ##1\ }
    \fi}{}
  \ifdox@macrolike
    \def\@doxexpr{\@doxcreatespecialmainmacrolikeindex{#2}}%
  \else
    \def\@doxexpr{\@doxcreatespecialmainindex{#2}}%
  \fi
  \expandafter\@doxexpr\expandafter{\dox@idxtype}{#4}%
  \@ifundefined{PrintDescribe#2}{%
    \ifdox@macrolike
      \expandafter\def\csname PrintDescribe#2\endcsname##1{%
        \strut\MacroFont\string ##1\ }
    \else
      \expandafter\def\csname PrintDescribe#2\endcsname##1{%
        \strut\MacroFont ##1\ }
    \fi}{}
  \ifdox@macrolike
    \def\@doxexpr{\@doxcreatespecialmacrolikeindex{#2}}%
  \else
    \def\@doxexpr{\@doxcreatespecialindex{#2}}%
  \fi
  \expandafter\@doxexpr\expandafter{\dox@idxtype}{#4}%
  \@doxcreatedescribe{#2}
  \@doxcreateenv{#2}{#3}%
}
\CheckCommand\doxitem[4][]{%
  \@nameuse{dox@macrolike\dox@macrolikedefault}%
  \def\dox@idxtype{#3}%
  \setkeys{dox}{#1}
  \@ifundefined{Print#2Name}{%
    \ifdox@macrolike
      \expandafter\def\csname Print#2Name\endcsname##1{%
        \strut\MacroFont\string ##1\ }
    \else
      \expandafter\def\csname Print#2Name\endcsname##1{%
        \strut\MacroFont ##1\ }
    \fi}{}
  \ifdox@macrolike
    \def\@doxexpr{\@doxcreatespecialmainmacrolikeindex{#2}}%
  \else
    \def\@doxexpr{\@doxcreatespecialmainindex{#2}}%
  \fi
  \expandafter\@doxexpr\expandafter{\dox@idxtype}{#4}%
  \@ifundefined{PrintDescribe#2}{%
    \ifdox@macrolike
      \expandafter\def\csname PrintDescribe#2\endcsname##1{%
        \strut\MacroFont\string ##1\ }
    \else
      \expandafter\def\csname PrintDescribe#2\endcsname##1{%
        \strut\MacroFont ##1\ }
    \fi}{}
  \ifdox@macrolike
    \def\@doxexpr{\@doxcreatespecialmacrolikeindex{#2}}%
  \else
    \def\@doxexpr{\@doxcreatespecialindex{#2}}%
  \fi
  \expandafter\@doxexpr\expandafter{\dox@idxtype}{#4}%
  \@doxcreatedescribe{#2}
  \@doxcreateenv{#2}{#3}%
}
\CheckCommand*\@doxcreateenv[2]{%
  \expandafter\def\csname #2\endcsname{%
    \@ifnextchar[%]
    {\@doxenv{#1}}{\@doxenv{#1}[]}}
  \expandafter\let\csname end#2\endcsname\endtrivlist%
}
\pretocmd{\@doxcreateenv}{%
  \ifdox@macrolike%
    \def\@doxexpr{\@doxcreatemacrolikeindexname{#1}}%
  \else%
    \def\@doxexpr{\@doxcreateindexname{#1}}%
  \fi%
  \expandafter\@doxexpr\expandafter{\dox@idxtype}%
}{}{\tud@patch@wrn{@doxcreateenv}}
\newcommand*\saved@idxtype{}
\def\@doxcreatemacrolikeindexname#1#2{%
  \expandafter\def\csname Set#1IndexName\endcsname##1{%
    \edef\saved@indexname{\expandafter\@gobble##1}%
    \edef\saved@idxtype{#2}%
  }%
}
\def\@doxcreateindexname#1#2{%
  \expandafter\def\csname Set#1IndexName\endcsname##1{%
    \let\saved@indexname##1%
    \edef\saved@idxtype{#2}%
  }%
}
\CheckCommand\@@doxenv[2]{%
  \endgroup%
  \topsep\MacroTopsep \trivlist%
  \edef\saved@macroname{\string#2}%
  \def\makelabel##1{\llap{##1}}%
  \if@inlabel%
    \let\@tempa\@empty%
    \count@\macro@cnt%
    \loop\ifnum\count@>\z@%
      \edef\@tempa{\@tempa\hbox{\strut}}\advance\count@\m@ne%
    \repeat%
    \edef\makelabel##1{\llap{\vtop to\baselineskip{\@tempa\hbox{##1}\vss}}}%
    \advance\macro@cnt\@ne%
  \else%
    \macro@cnt\@ne%
  \fi%
  \ifdox@noprint%
    \item%
  \else%
    \edef\@tempa{%
      \noexpand\item[%
      \expandafter\noexpand\csname Print#1Name\endcsname{\saved@macroname}]}%
    \@tempa%
  \fi%
  \ifdox@noindex\else%
    \global\advance\c@CodelineNo\@ne%
    \@nameuse{SpecialMain#1Index}{#2}\nobreak%
    \global\advance\c@CodelineNo\m@ne%
  \fi%
  \ignorespaces%
}
\patchcmd{\@@doxenv}{\ignorespaces}{%
  \csname Set#1IndexName\endcsname{\saved@macroname}\ignorespaces%
}{}{\tud@patch@wrn{@@doxenv}}
\def\SetMacroIndexName#1{%
  \edef\saved@indexname{\expandafter\@gobble#1}
  \let\saved@idxtype\@empty%
}
\def\SetEnvIndexName#1{%
  \let\saved@indexname#1%
  \edef\saved@idxtype{environment}%
}
\CheckCommand*\SpecialMainMacroIndex[1]{%
  \SpecialMainIndex{#1}\nobreak%
  \DoNotIndex{#1}%
}
\apptocmd{\SpecialMainMacroIndex}{%
  \hypersourcedef{\filesep\number\c@CodelineNo}%
}{}{\tud@patch@wrn{SpecialMainMacroIndex}}
\doxitem[idxtype=Umgebung]{Env}{environment}{Umgebungen}
\doxitem[idxtype=Option]{Option}{option}{Optionen}
\doxitem[idxtype=Parameter]{Parameter}{parameter}{Parameter}
\doxitem[idxtype=Seitenstil]{PageStyle}{pagestyle}{Seitenstile}
\doxitem[idxtype=Layer]{Layer}{layer}{Layer (Seitenstilebenen)}
\doxitem[macrolike,idxtype=L\noexpand\"ange]{Length}{length}{L\noexpand\"angen}
\doxitem[idxtype=Z\noexpand\"ahler]{Counter}{counter}{Z\noexpand\"ahler}
\doxitem[idxtype=Farbe]{Color}{color}{Farben}
\doxitem[macrolike,idxtype=Lok.]{Locale}{locale}{Lokalisierungsvariablen}
\doxitem[macrolike,idxtype=Feld]{Field}{field}{Eingabefelder}
\doxitem[idxtype=Schriftelement]{Font}{KOMAfont}{Schriftelemente}
\ifdefined\tudxdyflag
  \newcommand*\tud@write@replace{}
  \newwrite\tud@write@replace
  \newcommand*\tud@read@replace{}
  \newread\tud@read@replace
  \def\actualchar{<&1&>}
  \def\quotechar{<&2&>}
  \def\levelchar{<&3&>}
  \begingroup
    \endlinechar=-1\relax%
    \def\tud@reserved#1#2{%
      \immediate\openin\tud@read@replace=\jobname.#1\relax%
      \immediate\openout\tud@write@replace=\jobname-xdy.#1\relax%
      \@tempswafalse%
      \loop\unless\ifeof\tud@read@replace%
        \readline\tud@read@replace to\tud@line@replace%
        \tud@replace\tud@line@replace{"}{""}%
        \tud@replace\tud@line@replace{!}{"!}%
        \tud@replace\tud@line@replace{:}{":}%
        \tud@replace\tud@line@replace{@}{"@}%
        \tud@replace\tud@line@replace{\"@}{"\@backslashchar"@}%
        \expandafter\tud@replace\expandafter\tud@line@replace%
          \expandafter{\actualchar}{@}%
        \expandafter\tud@replace\expandafter\tud@line@replace%
          \expandafter{\quotechar}{"}%
        \expandafter\tud@replace\expandafter\tud@line@replace%
          \expandafter{\levelchar}{!}%
        \tud@replace\tud@line@replace{" @}{}%
        \ifeof\tud@read@replace\else%
          \immediate\write\tud@write@replace{%
            \unexpanded\expandafter{\tud@line@replace}%
          }%
          \@tempswatrue%
        \fi%
      \repeat%
      \immediate\closein\tud@read@replace%
      \immediate\closeout\tud@write@replace%
      \ifnum\pdfshellescape=\@ne\relax%
        \if@tempswa%
          \immediate\write18{%
            texindy\space%
              -o \jobname.#2\space%
              -M \@currname-#2.xdy\space%
              -L german-din\space%
              -t \jobname-#2.xlg\space%
            \jobname-xdy.#1
          }%
        \else%
          \immediate\openout\tud@write@replace=\jobname.#2\relax%
          \immediate\closeout\tud@write@replace%
        \fi%
      \fi%
    }%
    \tud@reserved{idx}{ind}%
    \tud@reserved{glo}{gls}%
  \endgroup
\else
  \ifnum\pdfshellescape=\@ne\relax%
    \immediate\write18{makeindex -s gglo.ist -o \jobname.gls \jobname.glo}%
    \immediate\write18{makeindex -s gind.ist -o \jobname.ind \jobname.idx}%
  \fi%
\fi
\IndexPrologue{%
  \addsec{Index}%
  Unterstrichene Zahlen, die gegebenenfalls mit einem Hyperlink versehen sind,
  verweisen auf die \ifcodeline@index Codezeile der \fi Definition, alle
  weiteren sind \ifcodeline@index Zeilennummern\else Seitenzahlen\fi, wo der
  jeweilige Eintrag verwendet wird.
}
\GlossaryPrologue{\addsec{\"Anderungsliste}}
\DeclareNewTOC[%
  type=todo,%
  listname={Liste der noch zu erledigenden Punkte},%
  name=ToDo,%
  tocentryindent=\z@,%
  owner=\@currname,%
]{tdo}
\setuptoc{tdo}{totoc}
\newcommand*\PrintToDos{\ifdefined\tudfinalflag\else\listoftodos\fi}
\patchcmd{\@docinclude}{%
  \let\@ltxdoc@PrintIndex\PrintIndex
  \let\PrintIndex\relax
  \let\@ltxdoc@PrintChanges\PrintChanges
  \let\PrintChanges\relax
}{%
  \let\@ltxdoc@PrintIndex\PrintIndex
  \let\PrintIndex\relax
  \let\@ltxdoc@PrintChanges\PrintChanges
  \let\PrintChanges\relax
  \let\@ltxdoc@PrintToDos\PrintToDos
  \let\PrintToDos\relax
}{}{\tud@patch@wrn{@docinclude}}
\patchcmd{\@docinclude}{%
  \let\PrintIndex\@ltxdoc@PrintIndex
  \let\PrintChanges\@ltxdoc@PrintChanges
}{%
  \let\PrintIndex\@ltxdoc@PrintIndex
  \let\PrintChanges\@ltxdoc@PrintChanges
  \let\PrintToDos\@ltxdoc@PrintToDos
}{}{\tud@patch@wrn{@docinclude}}
\newcommand*\ToDo[2][]{%
  \kernel@ifnextchar[{\@ToDo{#2}}{\@ToDo{#2}[]}%
}
\newcommand*\@ToDo{}
\def\@ToDo#1[#2]{%
  \ifdefined\tudfinalflag\else%
    \begingroup%
      \csuse{phantomsection}%
      \def\tud@reserved{\ifxblank{#2}{ToDo: ??}{ToDo: #2}}%
      \endgraf%
      \hfuzz0.8pt%
      \leavevmode\marginpar{\raggedleft\fbox{\tud@reserved\strut}}%
      \fbox{\parbox{\dimexpr\textwidth-2\fboxsep\relax}{#1\strut}}%
      \endgraf%
      \global\advance\c@CodelineNo\@ne
      \addxcontentsline{tdo}{todo}{#2:~#1~(\filesep\number\c@CodelineNo)}%
      \global\advance\c@CodelineNo\m@ne
    \endgroup%
  \fi%
}
\AtBeginDocument{%
  \@ifpackageloaded{etoolbox}{}{%
    \providecommand*\newrobustcmd{\DeclareRobustCommand}%
  }%
  \newrobustcmd*\app[1]{\mbox{\textsl{\textbf{#1}}}}
  \newrobustcmd*\cls[1]{\mbox{\textsf{\textbf{#1}}}}
  \newrobustcmd*\pkg[1]{\mbox{\textsf{\textbf{#1}}}}
  \newrobustcmd*\opt[1]{\mbox{\texttt{#1}}}
  \newrobustcmd*\val[1]{\mbox{\texttt{#1}}}
  \newrobustcmd*\pgs[1]{\mbox{\texttt{#1}}}
  \newrobustcmd*\env[1]{\mbox{\texttt{#1}}}
  \newrobustcmd*\file[1]{\mbox{\texttt{#1}}}
  \@ifpackageloaded{hyperref}{%
    \pdfstringdefDisableCommands{%
      \def\TUDScript{TUD-Script}%
      \let\cls\@firstofone%
      \let\pkg\@firstofone%
    }%
  }{%
    \RequirePackage{url}[2013/09/16]%
    \providecommand*\hypersetup[1]{}%
    \providecommand*\phantomsection{}%
    \providecommand*\texorpdfstring[2]{#1}%
  }%
  \@ifpackageloaded{babel}{}{%
    \ClassWarning{\TUD@Class@Name}{Package `babel' not loaded}%
    \let\selectlanguage\@gobble%
    \let\glqq\relax%
    \let\grqq\relax%
  }%
  \@ifpackageloaded{csquotes}{}{%
    \ClassWarning{\TUD@Class@Name}{Package `csquotes' not loaded}%
    \providecommand\enquote[1]{\glqq#1\grqq{}}%
  }%
  \@ifpackageloaded{tudscrfonts}{%
    \RequirePackage{mweights}[2013/07/21]%
    \ifnum\tud@cdfont@num>\z@\relax% true/heavy
      \def\mddefault{m}%
      \def\mdseries@tt{m}%
      \renewcommand*\@pnumwidth{1.7em}%
      \renewcommand*\@tocrmarg{2.7em}%
    \fi%
    \setlength\columnsep{10pt}%
  }{%
    \RequirePackage{lmodern}[2009/10/30]%
    \providecommand*\ifdin[2]{#2}%
    \providecommand*\textuln[1]{\textsf{#1}}%
    \providecommand*\texturn[1]{\textuln{#1}}%
    \providecommand*\textubn[1]{\textbf{\textuln{#1}}}%
    \providecommand*\textuxn[1]{\textubn{#1}}%
    \providecommand*\textuls[1]{\textsl{\textuln{#1}}}%
    \providecommand*\texturs[1]{\textuls{#1}}%
    \providecommand*\textubs[1]{\textbf{\textuls{#1}}}%
    \providecommand*\textuxs[1]{\textubs{#1}}%
    \providecommand*\textdbn[1]{\textubn{#1}}%
  }%
  \title{%
    \file{\filename}\thanks{%
      Dies ist Version \fileversion\nobreakspace{}von Datei \file{\filename}.%
    }%
  }%
  \author{Falk Hanisch\thanks{\tudscrmail}}%
  \date{\filedate}%
}
%%% From File: tudscr-manual.dtx
\RequirePackage{scrhack}[2014/02/27]
\RequirePackage{xspace}[2009/10/20]
\xspaceaddexceptions{"=}
\newcommand*\vTUDScript{v\TUDScriptVersionNumber}
\newcommand*\vKOMAScript{v\TUD@Version@KOMA}
\newcommand*\tud@english[1]{#1}
\AtBeginDocument{%
  \providecommand*\iflanguageloaded[3]{#3}%
  \iflanguageloaded{english}{%
    \renewcommand*\tud@english[1]{\foreignlanguage{english}{#1}}%
  }{}%
}
\newcommand*\CD{\tud@english{Corporate Design}\xspace}
\newcommand*\CDs{\tud@english{Corporate Designs}\xspace}
\newcommand*\TUD{Technische Universit\"at Dresden\xspace}
\newcommand*\TnUD{Technischen Universit\"at Dresden\xspace}
\newcommand*\TUDCD{\CD der \TnUD}
\newcommand*\TUDCDs{\CDs der \TnUD}
\AtBeginDocument{%
\newrobustcmd*\DDC{%
  \mbox{%
    D\kern.05em R\kern.05em E\kern.05em S\kern.05em %
    D\kern.05em E\kern.05em N\kern.1em-\kern.1em concept%
  }\xspace%
}
}
\newcommand*\Univers{\texorpdfstring{\textubn{Univers}}{Univers}\xspace}
\newcommand*\DIN{\texorpdfstring{\textdbn{DIN~BOLD}}{DIN BOLD}\xspace}
%%% From File: tudscr-misc.dtx
\catcode`\#=12
\newcommand*\@hashchar{#}
\catcode`\#=6
\newcommand*\tud@lst@def{%
  \newcommand*\tud@lst@values{}%
  \newif\if@tud@lst@multi%
  \newcommand*\tud@lst@init{%
    \let\tud@lst@values\relax%
    \@tud@lst@multifalse%
  }%
  \newcommand*\tud@lst@add[1]{%
    \ifx\tud@lst@values\relax\else%
      \@tud@lst@multitrue%
    \fi%
    \listadd\tud@lst@values{##1}%
  }%
  \newcommand*\tud@lst@process{%
    \def\tud@reserved{}%
    \if@tud@lst@multi%
      \def\tud@reserved{\subsubitem}%
      \efill%
    \fi%
    \forlistloop\tud@reserved{\tud@lst@values}%
  }%
}
\begingroup
\ifdef{\tudxdyflag}{%
\newcommand*\tud@write@xdy{}
\newwrite\tud@write@xdy
\newif\if@tud@xdy@glo
\newcommand*\tud@xdy@create[2][theindex]{%
  \IfFileExists{\@currname-#2.xdy}{}{%
  \ifstr{#1}{theglossary}{\@tud@xdy@glotrue}{\@tud@xdy@glofalse}%
  \openout\tud@write@xdy=\@currname-#2.xdy\relax%
  \write\tud@write@xdy{(require "texindy.xdy")}%
  \write\tud@write@xdy{%
    (markup-index^^J%
    \space\space:open^^J%
    "\string\begin{#1}^^J%
    \space\space%
    \string\providecommand*\string\lettergroupDefault[1]{\@percentchar^^J%
    \@spaces\string\par%
    \string\centerline{\string\textbf{\string\textsf{Symbole}}}%
    \string\par\@percentchar^^J%
    \@spaces\string\nopagebreak\@percentchar^^J%
    \space\space}\@percentchar^^J%
    \space\space%
    \string\providecommand*\string\lettergroup[1]{\@percentchar^^J%
    \@spaces\string\par%
    \string\centerline{\string\textbf{\string\textsf{\@hashchar1}}}%
    \string\par\@percentchar^^J%
    \@spaces\string\nopagebreak\@percentchar^^J%
    \space\space}\@percentchar^^J%
    \space\space\string\makeatletter\@percentchar^^J%
    \space\space\string\scan@allowedfalse\@percentchar%
  }%
  \if@tud@xdy@glo%
  \write\tud@write@xdy{%
    \space\space\string\newcommand*\string\@lettergroup{}\@percentchar^^J%
    \space\space%
    \string\def\string\@lettergroup\@hashchar1\string\relax%
    {\string\lettergroup{\@hashchar1}}\@percentchar^^J%
    \space\space\string\tud@lst@def\@percentchar%
  }%
  \fi%
  \write\tud@write@xdy{%
    "^^J%
    \space\space:close "\string~n\string~n\string\end{#1}\string~n"^^J%
    \space\space:hierdepth 3^^J%
    )%
  }%
  \write\tud@write@xdy{%
    (define-location-class^^J%
    \space\space"arabic-page-numbers" ("arabic-numbers")%
    \space:min-range-length 1^^J%
    )^^J%
    (define-alphabet "AlphaExtended"^^J%
    \space(^^J%
    \space\space"A" "B" "C" "D" "E" "F" "G" "H" "I" "J" "K" "L" "M"^^J%
    \space\space"N" "O" "P" "Q" "R" "S" "T" "U" "V" "W" "X" "Y" "Z"^^J%
    \space\space"a" "b" "c" "d" "e" "f" "g" "h" "i" "j" "k" "l" "m"^^J%
    \space\space"n" "o" "p" "q" "r" "s" "t" "u" "v" "w" "x" "y" "z"^^J%
    \space\space"?"^^J%
    \space)^^J%
    )^^J%
    (define-location-class^^J%
    \space\space"part" ("AlphaExtended" :sep "-" "arabic-numbers")%
    \space:min-range-length 1^^J%
    )^^J%
    (markup-range :sep "--")%
  }%
  \if@tud@xdy@glo%
  \write\tud@write@xdy{%
    (markup-locclass-list%
    \space:open "\string\pfill\string\hypersourceref{" :close "}\string\relax"%
    )%
  }%
  \else%
  \write\tud@write@xdy{%
    (markup-locclass-list%
    \space:open "\string\pfill\space"%
    \space:close "\string\relax"%
    )%
  }%
  \fi%
  \write\tud@write@xdy{%
    (merge-rule "\@backslashchar[(.*)\@backslashchar]" "" :eregexp)%
    ^^J%
    (merge-rule%
    \space"\string^(@+)([\string^@~n]*)"%
    \space"\string\2\string~e\string\1"%
    \space:eregexp :again%
    )^^J%
    (merge-rule%
    \space"(.*)(@@@@)([\string^@~n]*)"%
    \space"\string\1@@@\string\3\string~e"%
    \space:again :eregexp%
    )^^J%
    (merge-rule%
    \space"(.*)(@@@)([\string^@~n]*)"%
    \space"\string\1@@\string\3\string~e"%
    \space:again :eregexp%
    )^^J%
    (merge-rule%
    \space"(.*)(@@)([\string^@~n]*)"%
    \space"\string\1@\string\3\string~e"%
    \space:eregexp :again%
    )^^J%
    (merge-rule%
    \space"(.*?)(@)([\string^@~n]*)"%
    \space"\string\1\string~b\string\3"%
    \space:eregexp :again%
    )
  }%
  \if@tud@xdy@glo%
  \write\tud@write@xdy{%
    (markup-letter-group%
    \space:open-head "\string~n\space\space\string\@gobble{"%
    \space:close-head "}"%
    )^^J%
    (markup-indexentry-list%
    \space:sep "\string~n\string~n\space\space\string\indexspace\string~n"%
    \space:depth 0%
    )^^J%
    (markup-indexentry\@spaces\space\space%
    :open "\string~n\space\space\string\@lettergroup\space"\space:depth 0%
    )^^J%
    (markup-indexentry-list :open "\string\relax" :depth 1)^^J%
    (markup-indexentry\@spaces\space\space%
    :open "\string~n\space\space\string\item\space" :depth 1%
    )^^J%
    (markup-indexentry-list :open "\string\efill" :depth 2)^^J%
    (markup-indexentry\@spaces\space\space%
    :open "\string~n\@spaces\string\subitem\space" :depth 2%
    )^^J%
    (markup-indexentry-list^^J%
    \space\space:open \space"\string\tud@lst@init"^^J%
    \space\space:close "\string~n \@spaces\space\string\tud@lst@process"^^J%
    \space\space:depth 3^^J%
    )^^J%
    (markup-indexentry^^J%
    \space\space:open \space"\string~n\@spaces\space\string\tud@lst@add{"^^J%
    \space\space:close "}"^^J%
    \space\space:depth 3^^J%
    )%
  }%
  \else%
  \write\tud@write@xdy{%
    (markup-indexentry-list :open "\string\efill" :depth 1)%
  }%
  \fi%
  \if@tud@xdy@glo\else%
  \write\tud@write@xdy{%
    (define-attributes (("main" "usage" "default")))^^J%
    (markup-locref :attr "main"%
    \space\space:open "\string\main{"\space\space:close "}"%
    )^^J%
    (markup-locref :attr "usage"%
    \space:open "\string\usage{"\space:close "}"%
    )%
  }%
  \fi%
  \closeout\tud@write@xdy%
  }%
}
\tud@xdy@create{ind}
\tud@xdy@create[theglossary]{gls}
}{}
\endgroup
\endinput
%%
%% End of file `tudscrdoc.cls'.
