/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.write.bytes;

import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;

public class EncodeUM {
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    public static final byte[] sHexDigits;
    public static final int[] b64_xtable;

    public static void encodeUM(Object runtime, ByteList lCurElemString, int occurrences, boolean ignoreStar, char type, ByteList result) {
        if (occurrences == 0 && type == 'm' && !ignoreStar) {
            EncodeUM.encodes(runtime, result, lCurElemString.getUnsafeBytes(), lCurElemString.getBegin(), lCurElemString.length(), lCurElemString.length(), (byte)type, false);
            return;
        }
        int n = occurrences = occurrences <= 2 ? 45 : occurrences / 3 * 3;
        if (lCurElemString.length() == 0) {
            return;
        }
        byte[] charsToEncode = lCurElemString.getUnsafeBytes();
        for (int i = 0; i < lCurElemString.length(); i += occurrences) {
            EncodeUM.encodes(runtime, result, charsToEncode, i + lCurElemString.getBegin(), lCurElemString.length() - i, occurrences, (byte)type, true);
        }
    }

    private static ByteList encodes(Object runtime, ByteList io2Append, byte[] charsToEncode, int startIndex, int length, int charCount, byte encodingType, boolean tailLf) {
        byte lNextChar;
        byte lCurChar;
        byte lPadding;
        byte[] lTranslationTable;
        charCount = charCount < length ? charCount : length;
        io2Append.ensure(charCount * 4 / 3 + 6);
        int i = startIndex;
        byte[] byArray = lTranslationTable = encodingType == 117 ? uu_table : b64_table;
        if (encodingType == 117) {
            if (charCount >= lTranslationTable.length) {
                throw new UnsupportedOperationException();
            }
            io2Append.append(lTranslationTable[charCount]);
            lPadding = 96;
        } else {
            lPadding = 61;
        }
        while (charCount >= 3) {
            lCurChar = charsToEncode[i++];
            lNextChar = charsToEncode[i++];
            byte lNextNextChar = charsToEncode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append(lTranslationTable[0x3F & lNextNextChar]);
            charCount -= 3;
        }
        if (charCount == 2) {
            lCurChar = charsToEncode[i++];
            lNextChar = charsToEncode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (charCount == 1) {
            lCurChar = charsToEncode[i++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        if (tailLf) {
            io2Append.append(10);
        }
        return io2Append;
    }

    static {
        int i;
        b64_xtable = new int[256];
        uu_table = StringOperations.plain("`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = StringOperations.plain("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = StringOperations.plain("0123456789abcdef0123456789ABCDEFx");
        for (i = 0; i < 256; ++i) {
            EncodeUM.b64_xtable[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            EncodeUM.b64_xtable[EncodeUM.b64_table[i]] = i;
        }
    }
}

