/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;

public class RubyRootNode
extends RootNode {
    private final RubyContext context;
    private final SharedMethodInfo sharedMethodInfo;
    private final boolean needsDeclarationFrame;
    @Node.Child
    private RubyNode body;

    public RubyRootNode(RubyContext context, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, boolean needsDeclarationFrame) {
        super(RubyLanguage.class, sourceSection, frameDescriptor);
        assert (sourceSection != null);
        assert (body != null);
        this.context = context;
        this.sharedMethodInfo = sharedMethodInfo;
        this.needsDeclarationFrame = needsDeclarationFrame;
        this.body = body;
        body.unsafeSetIsCall();
        body.unsafeSetIsRoot();
        if (context.getCallGraph() != null) {
            context.getCallGraph().registerRootNode(this);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.context.getSafepointManager().poll(this);
        return this.body.execute(frame);
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    @Override
    public boolean isCloningAllowed() {
        return true;
    }

    @Override
    public Node copy() {
        RubyRootNode cloned = (RubyRootNode)super.copy();
        if (this.context.getCallGraph() != null) {
            this.context.getCallGraph().registerRootNode(cloned);
        }
        return cloned;
    }

    @Override
    public String getName() {
        if (this.sharedMethodInfo.getName() != null) {
            return this.sharedMethodInfo.getName();
        }
        return this.sharedMethodInfo.getNotes();
    }

    @Override
    public String toString() {
        return this.sharedMethodInfo.getDescriptiveNameAndSource();
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public RubyNode getBody() {
        return this.body;
    }

    public boolean needsDeclarationFrame() {
        return this.needsDeclarationFrame;
    }

    public RubyContext getContext() {
        return this.context;
    }
}

