/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.function.Consumer;
import org.elasticsearch.common.CheckedConsumer;

public interface ActionListener<Response> {
    public void onResponse(Response var1);

    public void onFailure(Exception var1);

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure) {
        return new ActionListener<Response>(){

            @Override
            public void onResponse(Response response) {
                try {
                    onResponse.accept(response);
                }
                catch (Exception e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }
}

