/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Objects;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.StringHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.IndexConstraint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class FieldStats<T>
implements Writeable,
ToXContent {
    private final byte type;
    private long maxDoc;
    private long docCount;
    private long sumDocFreq;
    private long sumTotalTermFreq;
    private boolean isSearchable;
    private boolean isAggregatable;
    private boolean hasMinMax;
    protected T minValue;
    protected T maxValue;
    static final String TYPE_FIELD = new String("type");
    static final String MAX_DOC_FIELD = new String("max_doc");
    static final String DOC_COUNT_FIELD = new String("doc_count");
    static final String DENSITY_FIELD = new String("density");
    static final String SUM_DOC_FREQ_FIELD = new String("sum_doc_freq");
    static final String SUM_TOTAL_TERM_FREQ_FIELD = new String("sum_total_term_freq");
    static final String SEARCHABLE_FIELD = new String("searchable");
    static final String AGGREGATABLE_FIELD = new String("aggregatable");
    static final String MIN_VALUE_FIELD = new String("min_value");
    static final String MIN_VALUE_AS_STRING_FIELD = new String("min_value_as_string");
    static final String MAX_VALUE_FIELD = new String("max_value");
    static final String MAX_VALUE_AS_STRING_FIELD = new String("max_value_as_string");

    FieldStats(byte type, long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable) {
        this.type = type;
        this.maxDoc = maxDoc;
        this.docCount = docCount;
        this.sumDocFreq = sumDocFreq;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.hasMinMax = false;
    }

    FieldStats(byte type, long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable, T minValue, T maxValue) {
        Objects.requireNonNull(minValue, "minValue must not be null");
        Objects.requireNonNull(maxValue, "maxValue must not be null");
        this.type = type;
        this.maxDoc = maxDoc;
        this.docCount = docCount;
        this.sumDocFreq = sumDocFreq;
        this.sumTotalTermFreq = sumTotalTermFreq;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.hasMinMax = true;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    byte getType() {
        return this.type;
    }

    public String getDisplayType() {
        switch (this.type) {
            case 0: {
                return "integer";
            }
            case 1: {
                return "float";
            }
            case 2: {
                return "date";
            }
            case 3: {
                return "string";
            }
            case 4: {
                return "ip";
            }
        }
        throw new IllegalArgumentException("Unknown type.");
    }

    public boolean hasMinMax() {
        return this.hasMinMax;
    }

    public long getMaxDoc() {
        return this.maxDoc;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public int getDensity() {
        if (this.docCount < 0L || this.maxDoc <= 0L) {
            return -1;
        }
        return (int)(this.docCount * 100L / this.maxDoc);
    }

    public long getSumDocFreq() {
        return this.sumDocFreq;
    }

    public long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public abstract String getMinValueAsString();

    public abstract String getMaxValueAsString();

    protected abstract T valueOf(String var1, String var2);

    public final void accumulate(FieldStats other) {
        this.maxDoc += other.maxDoc;
        if (other.docCount == -1L) {
            this.docCount = -1L;
        } else if (this.docCount != -1L) {
            this.docCount += other.docCount;
        }
        if (other.sumDocFreq == -1L) {
            this.sumDocFreq = -1L;
        } else if (this.sumDocFreq != -1L) {
            this.sumDocFreq += other.sumDocFreq;
        }
        if (other.sumTotalTermFreq == -1L) {
            this.sumTotalTermFreq = -1L;
        } else if (this.sumTotalTermFreq != -1L) {
            this.sumTotalTermFreq += other.sumTotalTermFreq;
        }
        this.isSearchable |= other.isSearchable;
        this.isAggregatable |= other.isAggregatable;
        assert (this.type == other.getType());
        if (this.hasMinMax && other.hasMinMax) {
            this.updateMinMax(other.minValue, other.maxValue);
        } else {
            this.hasMinMax = false;
            this.minValue = null;
            this.maxValue = null;
        }
    }

    private void updateMinMax(T min, T max) {
        if (this.compare(this.minValue, min) > 0) {
            this.minValue = min;
        }
        if (this.compare(this.maxValue, max) < 0) {
            this.maxValue = max;
        }
    }

    protected abstract int compare(T var1, T var2);

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD, this.getDisplayType());
        builder.field(MAX_DOC_FIELD, this.maxDoc);
        builder.field(DOC_COUNT_FIELD, this.docCount);
        builder.field(DENSITY_FIELD, this.getDensity());
        builder.field(SUM_DOC_FREQ_FIELD, this.sumDocFreq);
        builder.field(SUM_TOTAL_TERM_FREQ_FIELD, this.sumTotalTermFreq);
        builder.field(SEARCHABLE_FIELD, this.isSearchable);
        builder.field(AGGREGATABLE_FIELD, this.isAggregatable);
        if (this.hasMinMax) {
            this.toInnerXContent(builder);
        }
        builder.endObject();
        return builder;
    }

    protected void toInnerXContent(XContentBuilder builder) throws IOException {
        builder.field(MIN_VALUE_FIELD, this.getMinValue());
        builder.field(MIN_VALUE_AS_STRING_FIELD, this.getMinValueAsString());
        builder.field(MAX_VALUE_FIELD, this.getMaxValue());
        builder.field(MAX_VALUE_AS_STRING_FIELD, this.getMaxValueAsString());
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.type);
        out.writeLong(this.maxDoc);
        out.writeLong(this.docCount);
        out.writeLong(this.sumDocFreq);
        out.writeLong(this.sumTotalTermFreq);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        if (out.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED)) {
            out.writeBoolean(this.hasMinMax);
            if (this.hasMinMax) {
                this.writeMinMax(out);
            }
        } else {
            assert (this.hasMinMax) : "cannot serialize null min/max fieldstats in a mixed-cluster with pre-" + Version.V_5_2_0_UNRELEASED + " nodes, remote version [" + out.getVersion() + "]";
            this.writeMinMax(out);
        }
    }

    protected abstract void writeMinMax(StreamOutput var1) throws IOException;

    public boolean match(IndexConstraint constraint) {
        int cmp;
        if (!this.hasMinMax) {
            return false;
        }
        T value = this.valueOf(constraint.getValue(), constraint.getOptionalFormat());
        if (constraint.getProperty() == IndexConstraint.Property.MIN) {
            cmp = this.compare(this.minValue, value);
        } else if (constraint.getProperty() == IndexConstraint.Property.MAX) {
            cmp = this.compare(this.maxValue, value);
        } else {
            throw new IllegalArgumentException("Unsupported property [" + (Object)((Object)constraint.getProperty()) + "]");
        }
        switch (constraint.getComparison()) {
            case GT: {
                return cmp > 0;
            }
            case GTE: {
                return cmp >= 0;
            }
            case LT: {
                return cmp < 0;
            }
            case LTE: {
                return cmp <= 0;
            }
        }
        throw new IllegalArgumentException("Unsupported comparison [" + (Object)((Object)constraint.getComparison()) + "]");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldStats that = (FieldStats)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.maxDoc != that.maxDoc) {
            return false;
        }
        if (this.docCount != that.docCount) {
            return false;
        }
        if (this.sumDocFreq != that.sumDocFreq) {
            return false;
        }
        if (this.sumTotalTermFreq != that.sumTotalTermFreq) {
            return false;
        }
        if (this.isSearchable != that.isSearchable) {
            return false;
        }
        if (this.isAggregatable != that.isAggregatable) {
            return false;
        }
        if (this.hasMinMax != that.hasMinMax) {
            return false;
        }
        if (!this.hasMinMax) {
            return true;
        }
        if (!this.minValue.equals(that.minValue)) {
            return false;
        }
        return this.maxValue.equals(that.maxValue);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.maxDoc, this.docCount, this.sumDocFreq, this.sumTotalTermFreq, this.isSearchable, this.isAggregatable, this.hasMinMax, this.minValue, this.maxValue);
    }

    public static FieldStats readFrom(StreamInput in) throws IOException {
        byte type = in.readByte();
        long maxDoc = in.readLong();
        long docCount = in.readLong();
        long sumDocFreq = in.readLong();
        long sumTotalTermFreq = in.readLong();
        boolean isSearchable = in.readBoolean();
        boolean isAggregatable = in.readBoolean();
        boolean hasMinMax = true;
        if (in.getVersion().onOrAfter(Version.V_5_2_0_UNRELEASED)) {
            hasMinMax = in.readBoolean();
        }
        switch (type) {
            case 0: {
                if (hasMinMax) {
                    return new Long(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, in.readLong(), in.readLong());
                }
                return new Long(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
            }
            case 1: {
                if (hasMinMax) {
                    return new Double(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, in.readDouble(), in.readDouble());
                }
                return new Double(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
            }
            case 2: {
                if (hasMinMax) {
                    FormatDateTimeFormatter formatter = Joda.forPattern(in.readString());
                    return new Date(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, formatter, in.readLong(), in.readLong());
                }
                return new Date(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
            }
            case 3: {
                if (hasMinMax) {
                    return new Text(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, in.readBytesRef(), in.readBytesRef());
                }
                return new Text(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
            }
            case 4: {
                if (!hasMinMax) {
                    return new Ip(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
                }
                byte l1 = in.readByte();
                byte[] b1 = new byte[l1];
                in.readBytes(b1, 0, l1);
                byte l2 = in.readByte();
                byte[] b2 = new byte[l2];
                in.readBytes(b2, 0, l2);
                InetAddress min = InetAddressPoint.decode((byte[])b1);
                InetAddress max = InetAddressPoint.decode((byte[])b2);
                return new Ip(maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, min, max);
            }
        }
        throw new IllegalArgumentException("Unknown type.");
    }

    public static class Ip
    extends FieldStats<InetAddress> {
        public Ip(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable) {
            super((byte)4, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
        }

        public Ip(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable, InetAddress minValue, InetAddress maxValue) {
            super((byte)4, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, minValue, maxValue);
        }

        @Override
        public int compare(InetAddress o1, InetAddress o2) {
            byte[] b1 = InetAddressPoint.encode((InetAddress)o1);
            byte[] b2 = InetAddressPoint.encode((InetAddress)o2);
            return StringHelper.compare((int)b1.length, (byte[])b1, (int)0, (byte[])b2, (int)0);
        }

        @Override
        public void writeMinMax(StreamOutput out) throws IOException {
            byte[] b1 = InetAddressPoint.encode((InetAddress)((InetAddress)this.minValue));
            byte[] b2 = InetAddressPoint.encode((InetAddress)((InetAddress)this.maxValue));
            out.writeByte((byte)b1.length);
            out.writeBytes(b1);
            out.writeByte((byte)b2.length);
            out.writeBytes(b2);
        }

        @Override
        public InetAddress valueOf(String value, String fmt) {
            return InetAddresses.forString(value);
        }

        @Override
        public String getMinValueAsString() {
            return NetworkAddress.format((InetAddress)this.minValue);
        }

        @Override
        public String getMaxValueAsString() {
            return NetworkAddress.format((InetAddress)this.maxValue);
        }
    }

    public static class Text
    extends FieldStats<BytesRef> {
        public Text(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable) {
            super((byte)3, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
        }

        public Text(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable, BytesRef minValue, BytesRef maxValue) {
            super((byte)3, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, minValue, maxValue);
        }

        @Override
        public int compare(BytesRef o1, BytesRef o2) {
            return o1.compareTo(o2);
        }

        @Override
        public void writeMinMax(StreamOutput out) throws IOException {
            out.writeBytesRef((BytesRef)this.minValue);
            out.writeBytesRef((BytesRef)this.maxValue);
        }

        @Override
        protected BytesRef valueOf(String value, String optionalFormat) {
            if (optionalFormat != null) {
                throw new UnsupportedOperationException("custom format isn't supported");
            }
            return new BytesRef((CharSequence)value);
        }

        @Override
        public String getMinValueAsString() {
            return ((BytesRef)this.minValue).utf8ToString();
        }

        @Override
        public String getMaxValueAsString() {
            return ((BytesRef)this.maxValue).utf8ToString();
        }

        @Override
        protected void toInnerXContent(XContentBuilder builder) throws IOException {
            builder.field(MIN_VALUE_FIELD, this.getMinValueAsString());
            builder.field(MAX_VALUE_FIELD, this.getMaxValueAsString());
        }
    }

    public static class Date
    extends FieldStats<java.lang.Long> {
        private FormatDateTimeFormatter formatter;

        public Date(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable) {
            super((byte)2, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
            this.formatter = null;
        }

        public Date(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable, FormatDateTimeFormatter formatter, long minValue, long maxValue) {
            super((byte)2, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, minValue, maxValue);
            this.formatter = formatter;
        }

        @Override
        public int compare(java.lang.Long o1, java.lang.Long o2) {
            return o1.compareTo(o2);
        }

        @Override
        public void writeMinMax(StreamOutput out) throws IOException {
            out.writeString(this.formatter.format());
            out.writeLong((java.lang.Long)this.minValue);
            out.writeLong((java.lang.Long)this.maxValue);
        }

        @Override
        public java.lang.Long valueOf(String value, String fmt) {
            FormatDateTimeFormatter f = this.formatter;
            if (fmt != null) {
                f = Joda.forPattern(fmt);
            }
            return f.parser().parseDateTime(value).getMillis();
        }

        @Override
        public String getMinValueAsString() {
            return this.formatter.printer().print(((java.lang.Long)this.minValue).longValue());
        }

        @Override
        public String getMaxValueAsString() {
            return this.formatter.printer().print(((java.lang.Long)this.maxValue).longValue());
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Date that = (Date)o;
            return Objects.equals(this.formatter == null ? null : this.formatter.format(), that.formatter == null ? null : that.formatter.format());
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.formatter == null ? 0 : this.formatter.format().hashCode());
            return result;
        }
    }

    public static class Double
    extends FieldStats<java.lang.Double> {
        public Double(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable) {
            super((byte)1, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
        }

        public Double(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable, double minValue, double maxValue) {
            super((byte)1, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, minValue, maxValue);
        }

        @Override
        public int compare(java.lang.Double o1, java.lang.Double o2) {
            return o1.compareTo(o2);
        }

        @Override
        public void writeMinMax(StreamOutput out) throws IOException {
            out.writeDouble((java.lang.Double)this.minValue);
            out.writeDouble((java.lang.Double)this.maxValue);
        }

        @Override
        public java.lang.Double valueOf(String value, String optionalFormat) {
            if (optionalFormat != null) {
                throw new UnsupportedOperationException("custom format isn't supported");
            }
            return java.lang.Double.parseDouble(value);
        }

        @Override
        public String getMinValueAsString() {
            return java.lang.Double.toString((java.lang.Double)this.minValue);
        }

        @Override
        public String getMaxValueAsString() {
            return java.lang.Double.toString((java.lang.Double)this.maxValue);
        }
    }

    public static class Long
    extends FieldStats<java.lang.Long> {
        public Long(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable) {
            super((byte)0, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable);
        }

        public Long(long maxDoc, long docCount, long sumDocFreq, long sumTotalTermFreq, boolean isSearchable, boolean isAggregatable, long minValue, long maxValue) {
            super((byte)0, maxDoc, docCount, sumDocFreq, sumTotalTermFreq, isSearchable, isAggregatable, minValue, maxValue);
        }

        @Override
        public int compare(java.lang.Long o1, java.lang.Long o2) {
            return o1.compareTo(o2);
        }

        @Override
        public void writeMinMax(StreamOutput out) throws IOException {
            out.writeLong((java.lang.Long)this.minValue);
            out.writeLong((java.lang.Long)this.maxValue);
        }

        @Override
        public java.lang.Long valueOf(String value, String optionalFormat) {
            return java.lang.Long.parseLong(value);
        }

        @Override
        public String getMinValueAsString() {
            return java.lang.Long.toString((java.lang.Long)this.minValue);
        }

        @Override
        public String getMaxValueAsString() {
            return java.lang.Long.toString((java.lang.Long)this.maxValue);
        }
    }
}

