/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.source.AppendableLiteralSourceImpl;
import com.oracle.truffle.api.source.BytesSourceImpl;
import com.oracle.truffle.api.source.ClientManagedFileSourceImpl;
import com.oracle.truffle.api.source.Content;
import com.oracle.truffle.api.source.FileSourceImpl;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.LiteralSourceImpl;
import com.oracle.truffle.api.source.MissingMIMETypeException;
import com.oracle.truffle.api.source.MissingNameException;
import com.oracle.truffle.api.source.SourceImpl;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.source.SubSourceImpl;
import com.oracle.truffle.api.source.TextMap;
import com.oracle.truffle.api.source.URLSourceImpl;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;

public abstract class Source {
    static boolean fileCacheEnabled = true;
    private static final Source EMPTY = new SourceImpl(new LiteralSourceImpl("<empty>", ""));
    private static final String NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE = "do not create sub sources from compiled code";
    private final Content content;
    private final URI uri;
    private final String name;
    private String mimeType;
    private final boolean internal;
    private final boolean interactive;
    private TextMap textMap;

    @Deprecated
    public static Source find(String name) {
        return SourceImpl.findSource(name);
    }

    public static Builder<IOException, RuntimeException, RuntimeException> newBuilder(File file) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, RuntimeException, RuntimeException>(file);
    }

    @Deprecated
    public static Source fromFileName(String fileName, boolean reload) throws IOException {
        Source source;
        if (!reload && (source = Source.find(fileName)) != null && source.content() instanceof FileSourceImpl) {
            return source;
        }
        File file = new File(fileName);
        if (!file.canRead()) {
            throw new IOException("Can't read file " + fileName);
        }
        String path = file.getCanonicalPath();
        FileSourceImpl content = new FileSourceImpl(Source.read(file), file, fileName, path);
        return new SourceImpl(content);
    }

    @Deprecated
    public static Source fromFileName(String fileName) throws IOException {
        return Source.fromFileName(fileName, false);
    }

    @Deprecated
    public static Source fromFileName(CharSequence chars, String fileName) throws IOException {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromFileName from compiled code");
        assert (chars != null);
        File file = new File(fileName);
        String path = file.getCanonicalPath();
        ClientManagedFileSourceImpl content = new ClientManagedFileSourceImpl(file, fileName, path, chars);
        SourceImpl source = new SourceImpl(content);
        return source;
    }

    @Deprecated
    public static Source fromText(CharSequence chars, String name) {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromText from compiled code");
        LiteralSourceImpl content = new LiteralSourceImpl(name, chars.toString());
        return new SourceImpl(content);
    }

    public static Builder<RuntimeException, MissingMIMETypeException, MissingNameException> newBuilder(String text) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<RuntimeException, MissingMIMETypeException, MissingNameException>(text);
    }

    @Deprecated
    public static Source fromAppendableText(String name) {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromAppendableText from compiled code");
        AppendableLiteralSourceImpl content = new AppendableLiteralSourceImpl(name);
        return new SourceImpl(content);
    }

    @Deprecated
    public static Source fromNamedText(CharSequence chars, String name) {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromNamedText from compiled code");
        LiteralSourceImpl content = new LiteralSourceImpl(name, chars.toString());
        SourceImpl source = new SourceImpl(content);
        return source;
    }

    @Deprecated
    public static Source fromNamedAppendableText(String name) {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromNamedAppendable from compiled code");
        AppendableLiteralSourceImpl content = new AppendableLiteralSourceImpl(name);
        SourceImpl source = new SourceImpl(content);
        return source;
    }

    @Deprecated
    public static Source subSource(Source base, int baseCharIndex, int length) {
        CompilerAsserts.neverPartOfCompilation(NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE);
        SubSourceImpl subSource = SubSourceImpl.create(base, baseCharIndex, length);
        return new SourceImpl(subSource);
    }

    public Source subSource(int baseCharIndex, int length) {
        CompilerAsserts.neverPartOfCompilation(NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE);
        SubSourceImpl subSource = SubSourceImpl.create(this, baseCharIndex, length);
        return new SourceImpl(subSource);
    }

    @Deprecated
    public static Source subSource(Source base, int baseCharIndex) {
        CompilerAsserts.neverPartOfCompilation(NO_FASTPATH_SUBSOURCE_CREATION_MESSAGE);
        return Source.subSource(base, baseCharIndex, base.getLength() - baseCharIndex);
    }

    @Deprecated
    public static Source fromURL(URL url, String description) throws IOException {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromURL from compiled code");
        URLSourceImpl content = URLSourceImpl.get(url, description);
        return new SourceImpl(content);
    }

    public static Builder<IOException, RuntimeException, RuntimeException> newBuilder(URL url) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, RuntimeException, RuntimeException>(url);
    }

    @Deprecated
    public static Source fromReader(Reader reader, String description) throws IOException {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromReader from compiled code");
        LiteralSourceImpl content = new LiteralSourceImpl(description, Source.read(reader));
        return new SourceImpl(content);
    }

    public static Builder<IOException, MissingMIMETypeException, MissingNameException> newBuilder(Reader reader) {
        Source source = EMPTY;
        source.getClass();
        return source.new Builder<IOException, MissingMIMETypeException, MissingNameException>(reader);
    }

    @Deprecated
    public static Source fromBytes(byte[] bytes, String name, Charset charset) {
        return Source.fromBytes(bytes, 0, bytes.length, name, charset);
    }

    @Deprecated
    public static Source fromBytes(byte[] bytes, int byteIndex, int length, String name, Charset charset) {
        CompilerAsserts.neverPartOfCompilation("do not call Source.fromBytes from compiled code");
        BytesSourceImpl content = new BytesSourceImpl(name, bytes, byteIndex, length, charset);
        return new SourceImpl(content);
    }

    @Deprecated
    public static void setFileCaching(boolean enabled) {
        fileCacheEnabled = enabled;
    }

    static String read(File file) throws IOException {
        return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String read(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        try {
            int n;
            while ((n = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, n);
            }
        }
        finally {
            reader.close();
        }
        return builder.toString();
    }

    Source(Content content, String mimeType, URI uri, String name, boolean internal, boolean interactive) {
        this.content = content;
        this.mimeType = mimeType;
        this.name = name;
        this.internal = internal;
        this.interactive = interactive;
        this.uri = uri;
    }

    Content content() {
        return this.content;
    }

    public String getName() {
        return this.name == null ? this.content().getName() : this.name;
    }

    @Deprecated
    public String getShortName() {
        return this.content().getShortName();
    }

    public String getPath() {
        return this.content().getPath();
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public URL getURL() {
        return this.content().getURL();
    }

    public URI getURI() {
        return this.uri == null ? this.content().getURI() : this.uri;
    }

    public Reader getReader() {
        try {
            return this.content().getReader();
        }
        catch (IOException ex) {
            return new Reader(){

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    throw ex;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    public final InputStream getInputStream() {
        return new ByteArrayInputStream(this.getCode().getBytes());
    }

    public final int getLength() {
        return this.getTextMap().length();
    }

    public String getCode() {
        return this.content().getCode();
    }

    public String getCode(int charIndex, int charLength) {
        return this.getCode().substring(charIndex, charIndex + charLength);
    }

    public final String getCode(int lineNumber) {
        int offset = this.getTextMap().lineStartOffset(lineNumber);
        int length = this.getTextMap().lineLength(lineNumber);
        return this.getCode().substring(offset, offset + length);
    }

    public final int getLineCount() {
        return this.getTextMap().lineCount();
    }

    public final int getLineNumber(int offset) throws IllegalArgumentException {
        return this.getTextMap().offsetToLine(offset);
    }

    public final int getColumnNumber(int offset) throws IllegalArgumentException {
        return this.getTextMap().offsetToCol(offset);
    }

    public final int getLineStartOffset(int lineNumber) throws IllegalArgumentException {
        return this.getTextMap().lineStartOffset(lineNumber);
    }

    public final int getLineLength(int lineNumber) throws IllegalArgumentException {
        return this.getTextMap().lineLength(lineNumber);
    }

    @Deprecated
    public void appendCode(CharSequence chars) {
        this.content().appendCode(chars);
        this.clearTextMap();
    }

    public final SourceSection createUnavailableSection() {
        return new SourceSection(this);
    }

    public final SourceSection createSection(int lineNumber) {
        if (lineNumber < 1) {
            throw new IllegalArgumentException("lineNumber < 1");
        }
        int charIndex = this.getTextMap().lineStartOffset(lineNumber);
        int length = this.getTextMap().lineLength(lineNumber);
        SourceSection section = new SourceSection(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    public final SourceSection createSection(int charIndex, int length) {
        if (charIndex < 0) {
            throw new IllegalArgumentException("charIndex < 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        SourceSection section = new SourceSection(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    public final SourceSection createSection(int startLine, int startColumn, int length) {
        if (startLine <= 0) {
            throw new IllegalArgumentException("startLine < 1");
        }
        if (startColumn <= 0) {
            throw new IllegalArgumentException("startColumn < 1");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        int lineStartOffset = this.getTextMap().lineStartOffset(startLine);
        if (startColumn > this.getTextMap().lineLength(startLine)) {
            throw new IllegalArgumentException("column out of range");
        }
        int charIndex = lineStartOffset + startColumn - 1;
        if (charIndex + length > this.getCode().length()) {
            throw new IllegalArgumentException("charIndex out of range");
        }
        SourceSection section = new SourceSection(this, charIndex, length);
        assert (Source.assertValid(section));
        return section;
    }

    private static boolean assertValid(SourceSection section) {
        if (!section.isValid()) {
            throw new IllegalArgumentException("Invalid source section bounds.");
        }
        return true;
    }

    @Deprecated
    public final SourceSection createSection(String identifier, int startLine, int startColumn, int charIndex, int length) {
        this.checkRange(charIndex, length);
        return this.createSectionImpl(identifier, startLine, startColumn, charIndex, length);
    }

    @Deprecated
    public final SourceSection createSection(int startLine, int startColumn, int charIndex, int length) {
        this.checkRange(charIndex, length);
        return this.createSectionImpl(startLine, startColumn, charIndex, length);
    }

    private SourceSection createSectionImpl(String identifier, int startLine, int startColumn, int charIndex, int length) {
        return new SourceSection(this, identifier, startLine, startColumn, charIndex, length);
    }

    private SourceSection createSectionImpl(int startLine, int startColumn, int charIndex, int length) {
        return new SourceSection(this, null, startLine, startColumn, charIndex, length);
    }

    @Deprecated
    public final SourceSection createSection(String identifier, int startLine, int startColumn, int length) {
        int lineStartOffset = this.getTextMap().lineStartOffset(startLine);
        if (startColumn > this.getTextMap().lineLength(startLine)) {
            throw new IllegalArgumentException("column out of range");
        }
        int startOffset = lineStartOffset + startColumn - 1;
        return this.createSectionImpl(identifier, startLine, startColumn, startOffset, length);
    }

    @Deprecated
    public final SourceSection createSection(String identifier, int charIndex, int length) throws IllegalArgumentException {
        this.checkRange(charIndex, length);
        int startLine = this.getLineNumber(charIndex);
        int startColumn = charIndex - this.getLineStartOffset(startLine) + 1;
        return this.createSectionImpl(identifier, startLine, startColumn, charIndex, length);
    }

    private void checkRange(int charIndex, int length) {
        if (charIndex < 0 || length < 0 || charIndex + length > this.getCode().length()) {
            throw new IllegalArgumentException("text positions out of range");
        }
    }

    @Deprecated
    public final SourceSection createSection(String identifier, int lineNumber) {
        int charIndex = this.getTextMap().lineStartOffset(lineNumber);
        int length = this.getTextMap().lineLength(lineNumber);
        return this.createSection(identifier, charIndex, length);
    }

    @Deprecated
    public final LineLocation createLineLocation(int lineNumber) {
        return new LineLocation(this, lineNumber);
    }

    Object getHashKey() {
        return this.content().getHashKey();
    }

    final TextMap getTextMap() {
        if (this.textMap == null) {
            this.textMap = this.createTextMap();
        }
        return this.textMap;
    }

    final void clearTextMap() {
        this.textMap = null;
    }

    TextMap createTextMap() {
        String code = this.getCode();
        if (code == null) {
            throw new RuntimeException("can't read file " + this.getName());
        }
        return TextMap.fromString(code);
    }

    @Deprecated
    public final Source withMimeType(String mime) {
        try {
            Source another = (Source)this.clone();
            another.mimeType = mime;
            return another;
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            try {
                this.mimeType = this.content().findMimeType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.mimeType;
    }

    final boolean equalAttributes(Source other) {
        return Objects.equals(this.getMimeType(), other.getMimeType()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getShortName(), other.getShortName()) && Objects.equals(this.getPath(), other.getPath());
    }

    static <E extends Exception> E raise(Class<E> type, Exception ex) throws E {
        throw ex;
    }

    public final class Builder<E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        private final Object origin;
        private URI uri;
        private String name;
        private String path;
        private String mime;
        private String content;
        private boolean internal;
        private boolean interactive;

        private Builder(Object origin) {
            this.origin = origin;
        }

        public Builder<E1, E2, RuntimeException> name(String newName) {
            Objects.requireNonNull(newName);
            this.name = newName;
            return this;
        }

        Builder<E1, E2, E3> path(String p) {
            this.path = p;
            return this;
        }

        public Builder<E1, RuntimeException, E3> mimeType(String newMimeType) {
            Objects.requireNonNull(newMimeType);
            this.mime = newMimeType;
            return this;
        }

        public Builder<E1, E2, E3> internal() {
            this.internal = true;
            return this;
        }

        public Builder<E1, E2, E3> interactive() {
            this.interactive = true;
            return this;
        }

        public Builder<E1, E2, E3> uri(URI ownUri) {
            Objects.requireNonNull(ownUri);
            this.uri = ownUri;
            return this;
        }

        public Builder<RuntimeException, E2, E3> content(String code) {
            this.content = code;
            return this;
        }

        Builder<E1, E2, E3> content(byte[] arr, int offset, int length, Charset encoding) {
            this.content = new String(arr, offset, length, encoding);
            return this;
        }

        public Source build() throws E1, E2, E3 {
            try {
                SourceImpl ret;
                String type;
                Content holder = this.origin instanceof File ? this.buildFile(this.content == null) : (this.origin instanceof Reader ? this.buildReader() : (this.origin instanceof URL ? this.buildURL() : this.buildString()));
                String string = type = this.mime == null ? holder.findMimeType() : this.mime;
                if (type == null) {
                    throw Source.raise(RuntimeException.class, new MissingMIMETypeException());
                }
                if (this.content != null) {
                    holder.code = this.content;
                }
                if ((ret = new SourceImpl(holder, type, this.uri, this.name, this.internal, this.interactive)).getName() == null) {
                    throw Source.raise(RuntimeException.class, new MissingNameException());
                }
                return ret;
            }
            catch (IOException ex) {
                throw Source.raise(RuntimeException.class, ex);
            }
        }

        private Content buildFile(boolean read) throws IOException {
            File file = (File)this.origin;
            File absoluteFile = file.getCanonicalFile();
            FileSourceImpl fileSource = new FileSourceImpl(read ? Source.read(file) : null, absoluteFile, this.name == null ? file.getName() : this.name, this.path == null ? absoluteFile.getPath() : this.path);
            return fileSource;
        }

        private Content buildReader() throws IOException {
            Reader r = (Reader)this.origin;
            if (this.content == null) {
                this.content = Source.read(r);
            }
            r.close();
            LiteralSourceImpl ret = new LiteralSourceImpl(null, this.content);
            return ret;
        }

        private Content buildURL() throws IOException {
            URL url = (URL)this.origin;
            String computedName = url.getPath().substring(url.getPath().lastIndexOf(47) + 1);
            URLSourceImpl ret = new URLSourceImpl(url, this.content, computedName);
            return ret;
        }

        private Content buildString() {
            String r = (String)this.origin;
            if (this.content == null) {
                this.content = r;
            }
            LiteralSourceImpl ret = new LiteralSourceImpl(null, this.content);
            return ret;
        }
    }
}

