/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.ByteList;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;

@CoreClass(value="Rubinius::ByteArray")
public abstract class ByteArrayNodes {
    public static DynamicObject createByteArray(DynamicObjectFactory factory, ByteList bytes) {
        return Layouts.BYTE_ARRAY.createByteArray(factory, bytes);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"locate"}, required=3, lowerFixnum={2, 3})
    public static abstract class LocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(pattern)"})
        public Object getByte(DynamicObject bytes, DynamicObject pattern, int start, int length) {
            Rope patternRope = StringOperations.rope(pattern);
            int index = new ByteList(Layouts.BYTE_ARRAY.getBytes(bytes), start, length).indexOf(patternRope);
            if (index == -1) {
                return this.nil();
            }
            return start + index + StringOperations.rope(pattern).characterLength();
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int size(DynamicObject bytes) {
            return Layouts.BYTE_ARRAY.getBytes(bytes).getRealSize();
        }
    }

    @CoreMethod(names={"set_byte", "[]="}, required=2, lowerFixnum={1, 2})
    public static abstract class SetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object setByte(DynamicObject bytes, int index, int value, @Cached(value="create()") BranchProfile errorProfile) {
            if (index < 0 || index >= Layouts.BYTE_ARRAY.getBytes(bytes).getRealSize()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().indexError("index out of bounds", this));
            }
            Layouts.BYTE_ARRAY.getBytes(bytes).set(index, value);
            return Layouts.BYTE_ARRAY.getBytes(bytes).get(index);
        }
    }

    @CoreMethod(names={"prepend"}, required=1)
    public static abstract class PrependNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject prepend(DynamicObject bytes, DynamicObject string) {
            Rope rope = StringOperations.rope(string);
            int prependLength = rope.byteLength();
            int originalLength = Layouts.BYTE_ARRAY.getBytes(bytes).getUnsafeBytes().length;
            int newLength = prependLength + originalLength;
            byte[] prependedBytes = new byte[newLength];
            System.arraycopy(rope.getBytes(), 0, prependedBytes, 0, prependLength);
            System.arraycopy(Layouts.BYTE_ARRAY.getBytes(bytes).getUnsafeBytes(), 0, prependedBytes, prependLength, originalLength);
            return ByteArrayNodes.createByteArray(this.coreLibrary().getByteArrayFactory(), new ByteList(prependedBytes));
        }
    }

    @CoreMethod(names={"get_byte", "[]"}, required=1, lowerFixnum={1})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int getByte(DynamicObject bytes, int index, @Cached(value="createBinaryProfile()") ConditionProfile nullByteIndexProfile) {
            ByteList byteList = Layouts.BYTE_ARRAY.getBytes(bytes);
            if (nullByteIndexProfile.profile(index == byteList.realSize())) {
                return 0;
            }
            return byteList.get(index) & 0xFF;
        }
    }
}

