/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;

public class ParserByteList {
    private final Rope rope;

    public ParserByteList(Rope rope) {
        this.rope = rope;
    }

    public ParserByteList(byte[] bytes) {
        this(bytes, ASCIIEncoding.INSTANCE);
    }

    public ParserByteList(byte[] bytes, Encoding encoding) {
        this(RopeOperations.create(bytes, encoding, CodeRange.CR_UNKNOWN));
    }

    public ParserByteList(byte[] bytes, int start, int length, Encoding encoding) {
        this(RopeOperations.create(Arrays.copyOfRange(bytes, start, start + length), encoding, CodeRange.CR_UNKNOWN));
    }

    public int getLength() {
        return this.rope.byteLength();
    }

    public Encoding getEncoding() {
        return this.rope.getEncoding();
    }

    public ParserByteList withEncoding(Encoding encoding) {
        return new ParserByteList(RopeOperations.create(this.getBytes(), encoding, CodeRange.CR_UNKNOWN));
    }

    public ParserByteList makeShared(int sharedStart, int sharedLength) {
        return new ParserByteList(this.getBytes(), sharedStart, sharedLength, this.getEncoding());
    }

    public int caseInsensitiveCmp(ParserByteList other) {
        return RopeOperations.caseInsensitiveCmp(this.rope, other.rope);
    }

    public boolean equal(ParserByteList other) {
        return this.rope.equals(other.rope);
    }

    public int charAt(int index) {
        return this.rope.get(index);
    }

    public String toString() {
        return RopeOperations.decodeRope(StandardCharsets.ISO_8859_1, this.rope);
    }

    public Rope toRope() {
        return this.rope;
    }

    public byte[] getBytes() {
        return this.rope.getBytes();
    }

    public CodeRange codeRangeScan() {
        return this.rope.getCodeRange();
    }

    public int getStringLength() {
        return this.rope.getEncoding().strLength(this.getBytes(), 0, this.getLength());
    }

    public int getEncodingLength(Encoding encoding) {
        return encoding.length(this.getBytes(), 0, this.getLength());
    }

    public String toEncodedString() {
        return RopeOperations.decodeRope(this.rope);
    }
}

