/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(value="child")
public abstract class ToProcNode
extends RubyNode {
    @Specialization(guards={"isNil(nil)"})
    public DynamicObject doNil(Object nil) {
        return this.nil();
    }

    @Specialization(guards={"isRubyProc(proc)"})
    public DynamicObject doRubyProc(DynamicObject proc) {
        return proc;
    }

    @Specialization(guards={"!isRubyProc(object)"})
    public DynamicObject doObject(VirtualFrame frame, Object object, @Cached(value="createCallNode()") CallDispatchHeadNode toProc, @Cached(value="create()") BranchProfile errorProfile) {
        Object coerced;
        try {
            coerced = toProc.call(frame, object, "to_proc", new Object[0]);
        }
        catch (RaiseException e) {
            errorProfile.enter();
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "Proc", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyProc(coerced)) {
            return (DynamicObject)coerced;
        }
        errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "Proc", "to_proc", coerced, this));
    }

    protected CallDispatchHeadNode createCallNode() {
        return DispatchHeadNodeFactory.createMethodCall();
    }
}

