/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.core.exception.CoreExceptions;
import org.jruby.truffle.core.format.exceptions.CantCompressNegativeException;
import org.jruby.truffle.core.format.exceptions.CantConvertException;
import org.jruby.truffle.core.format.exceptions.FormatException;
import org.jruby.truffle.core.format.exceptions.InvalidFormatException;
import org.jruby.truffle.core.format.exceptions.NoImplicitConversionException;
import org.jruby.truffle.core.format.exceptions.OutsideOfStringException;
import org.jruby.truffle.core.format.exceptions.RangeException;
import org.jruby.truffle.core.format.exceptions.TooFewArgumentsException;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;

public abstract class FormatExceptionTranslator {
    @CompilerDirectives.TruffleBoundary
    public static RuntimeException translate(RubyNode currentNode, FormatException exception) {
        CoreExceptions coreExceptions = currentNode.getContext().getCoreExceptions();
        if (exception instanceof TooFewArgumentsException) {
            return new RaiseException(coreExceptions.argumentErrorTooFewArguments(currentNode));
        }
        if (exception instanceof NoImplicitConversionException) {
            NoImplicitConversionException e = (NoImplicitConversionException)exception;
            return new RaiseException(coreExceptions.typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), currentNode));
        }
        if (exception instanceof OutsideOfStringException) {
            return new RaiseException(coreExceptions.argumentErrorXOutsideOfString(currentNode));
        }
        if (exception instanceof CantCompressNegativeException) {
            return new RaiseException(coreExceptions.argumentErrorCantCompressNegativeNumbers(currentNode));
        }
        if (exception instanceof RangeException) {
            RangeException e = (RangeException)exception;
            return new RaiseException(coreExceptions.rangeError(e.getMessage(), (Node)currentNode));
        }
        if (exception instanceof CantConvertException) {
            CantConvertException e = (CantConvertException)exception;
            return new RaiseException(coreExceptions.typeError(e.getMessage(), currentNode));
        }
        if (exception instanceof InvalidFormatException) {
            InvalidFormatException e = (InvalidFormatException)exception;
            return new RaiseException(coreExceptions.argumentError(e.getMessage(), (Node)currentNode));
        }
        throw new IllegalArgumentException();
    }
}

