/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.read.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.convert.ToStringNode;
import org.jruby.truffle.core.format.convert.ToStringNodeGen;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.write.bytes.WriteByteNodeGen;

@NodeChildren(value={@NodeChild(value="source", type=SourceNode.class)})
public abstract class ReadStringNode
extends FormatNode {
    private final boolean convertNumbersToStrings;
    private final String conversionMethod;
    private final boolean inspectOnConversionFailure;
    private final Object valueOnNil;
    @Node.Child
    private ToStringNode toStringNode;

    public ReadStringNode(boolean convertNumbersToStrings, String conversionMethod, boolean inspectOnConversionFailure, Object valueOnNil) {
        this.convertNumbersToStrings = convertNumbersToStrings;
        this.conversionMethod = conversionMethod;
        this.inspectOnConversionFailure = inspectOnConversionFailure;
        this.valueOnNil = valueOnNil;
    }

    @Specialization(guards={"isNull(source)"})
    public Object read(VirtualFrame frame, Object source) {
        this.advanceSourcePosition(frame);
        throw new IllegalStateException();
    }

    @Specialization
    public Object read(VirtualFrame frame, int[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    @Specialization
    public Object read(VirtualFrame frame, long[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    @Specialization
    public Object read(VirtualFrame frame, double[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    @Specialization
    public Object read(VirtualFrame frame, Object[] source) {
        return this.readAndConvert(frame, source[this.advanceSourcePosition(frame)]);
    }

    private Object readAndConvert(VirtualFrame frame, Object value) {
        if (this.toStringNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toStringNode = this.insert(ToStringNodeGen.create(this.convertNumbersToStrings, this.conversionMethod, this.inspectOnConversionFailure, this.valueOnNil, WriteByteNodeGen.create(new LiteralFormatNode((byte)0))));
        }
        return this.toStringNode.executeToString(frame, value);
    }
}

