/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.interop.ForeignToRubyNodeGen;
import org.jruby.truffle.language.RubyNode;

@NodeChild(value="value", type=RubyNode.class)
public abstract class ForeignToRubyNode
extends RubyNode {
    public static ForeignToRubyNode create() {
        return ForeignToRubyNodeGen.create(null);
    }

    public abstract Object executeConvert(VirtualFrame var1, Object var2);

    @Specialization(guards={"stringsEquals(cachedValue, value)"}, limit="getLimit()")
    public DynamicObject convertStringCached(String value, @Cached(value="value") String cachedValue, @Cached(value="getRope(value)") Rope cachedRope) {
        return this.createString(cachedRope);
    }

    @Specialization(contains={"convertStringCached"})
    public DynamicObject convertStringUncached(String value) {
        return this.createString(this.getRope(value));
    }

    protected boolean stringsEquals(String a, String b) {
        return a.equals(b);
    }

    protected Rope getRope(String value) {
        return StringOperations.encodeRope(value, UTF8Encoding.INSTANCE);
    }

    protected int getLimit() {
        return this.getContext().getOptions().INTEROP_CONVERT_CACHE;
    }

    @Specialization(guards={"!isString(value)"})
    public Object convert(Object value) {
        return value;
    }
}

