/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.HashSet;
import java.util.Set;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.Visibility;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.objects.ObjectGraphNode;

public class InternalMethod
implements ObjectGraphNode {
    private final SharedMethodInfo sharedMethodInfo;
    private final LexicalScope lexicalScope;
    private final String name;
    private final DynamicObject declaringModule;
    private final Visibility visibility;
    private final boolean undefined;
    private final boolean builtIn;
    private final DynamicObject proc;
    private final CallTarget callTarget;
    private final DynamicObject capturedBlock;
    private final DynamicObject capturedDefaultDefinee;

    public static InternalMethod fromProc(RubyContext context, SharedMethodInfo sharedMethodInfo, String name, DynamicObject declaringModule, Visibility visibility, DynamicObject proc, CallTarget callTarget) {
        return new InternalMethod(context, sharedMethodInfo, Layouts.PROC.getMethod(proc).getLexicalScope(), name, declaringModule, visibility, false, proc, callTarget, Layouts.PROC.getBlock(proc), null);
    }

    public InternalMethod(RubyContext context, SharedMethodInfo sharedMethodInfo, LexicalScope lexicalScope, String name, DynamicObject declaringModule, Visibility visibility, CallTarget callTarget) {
        this(context, sharedMethodInfo, lexicalScope, name, declaringModule, visibility, false, null, callTarget, null, null);
    }

    public InternalMethod(RubyContext context, SharedMethodInfo sharedMethodInfo, LexicalScope lexicalScope, String name, DynamicObject declaringModule, Visibility visibility, boolean undefined, DynamicObject proc, CallTarget callTarget, DynamicObject capturedBlock, DynamicObject capturedDefaultDefinee) {
        this(sharedMethodInfo, lexicalScope, name, declaringModule, visibility, undefined, !context.getCoreLibrary().isLoaded(), proc, callTarget, capturedBlock, capturedDefaultDefinee);
    }

    private InternalMethod(SharedMethodInfo sharedMethodInfo, LexicalScope lexicalScope, String name, DynamicObject declaringModule, Visibility visibility, boolean undefined, boolean builtIn, DynamicObject proc, CallTarget callTarget, DynamicObject capturedBlock, DynamicObject capturedDefaultDefinee) {
        assert (RubyGuards.isRubyModule(declaringModule));
        assert (lexicalScope != null);
        this.sharedMethodInfo = sharedMethodInfo;
        this.lexicalScope = lexicalScope;
        this.declaringModule = declaringModule;
        this.name = name;
        this.visibility = visibility;
        this.undefined = undefined;
        this.builtIn = builtIn;
        this.proc = proc;
        this.callTarget = callTarget;
        this.capturedBlock = capturedBlock;
        this.capturedDefaultDefinee = capturedDefaultDefinee;
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public DynamicObject getDeclaringModule() {
        return this.declaringModule;
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    public CallTarget getCallTarget() {
        return this.callTarget;
    }

    public InternalMethod withDeclaringModule(DynamicObject newDeclaringModule) {
        assert (RubyGuards.isRubyModule(newDeclaringModule));
        if (newDeclaringModule == this.declaringModule) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.name, newDeclaringModule, this.visibility, this.undefined, this.builtIn, this.proc, this.callTarget, this.capturedBlock, this.capturedDefaultDefinee);
    }

    public InternalMethod withName(String newName) {
        if (newName.equals(this.name)) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, newName, this.declaringModule, this.visibility, this.undefined, this.builtIn, this.proc, this.callTarget, this.capturedBlock, this.capturedDefaultDefinee);
    }

    public InternalMethod withVisibility(Visibility newVisibility) {
        if (newVisibility == this.visibility) {
            return this;
        }
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.name, this.declaringModule, newVisibility, this.undefined, this.builtIn, this.proc, this.callTarget, this.capturedBlock, this.capturedDefaultDefinee);
    }

    public InternalMethod undefined() {
        return new InternalMethod(this.sharedMethodInfo, this.lexicalScope, this.name, this.declaringModule, this.visibility, true, this.builtIn, this.proc, this.callTarget, this.capturedBlock, this.capturedDefaultDefinee);
    }

    public boolean isVisibleTo(DynamicObject callerClass) {
        assert (RubyGuards.isRubyClass(callerClass));
        switch (this.visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                for (DynamicObject ancestor : Layouts.MODULE.getFields(callerClass).ancestors()) {
                    if (ancestor != this.declaringModule && Layouts.BASIC_OBJECT.getMetaClass(ancestor) != this.declaringModule) continue;
                    return true;
                }
                return false;
            }
            case PRIVATE: {
                return false;
            }
        }
        throw new UnsupportedOperationException(this.visibility.name());
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }

    @Override
    public Set<DynamicObject> getAdjacentObjects() {
        HashSet<DynamicObject> adjacent = new HashSet<DynamicObject>();
        if (this.declaringModule != null) {
            adjacent.add(this.declaringModule);
        }
        if (this.proc != null) {
            adjacent.add(this.proc);
        }
        return adjacent;
    }

    public DynamicObject getCapturedBlock() {
        return this.capturedBlock;
    }

    public DynamicObject getCapturedDefaultDefinee() {
        return this.capturedDefaultDefinee;
    }

    public LexicalScope getLexicalScope() {
        return this.lexicalScope;
    }
}

