# -*- coding: utf-8 -*-
"""
    pint.compat.nullhandler
    ~~~~~~~~~~~~~~~~~~~~~~~

    Taken from the Python 2.7 source code.

    :copyright: 2013, PSF
    :license: PSF License
"""


import logging

class NullHandler(logging.Handler):
    """
    This handler does nothing. It's intended to be used to avoid the
    "No handlers could be found for logger XXX" one-off warning. This is
    important for library code, which may contain code to log events. If a user
    of the library does not configure logging, the one-off warning might be
    produced; to avoid this, the library developer simply needs to instantiate
    a NullHandler and add it to the top-level logger of the library module or
    package.
    """
    def handle(self, record):
        pass

    def emit(self, record):
        pass

    def createLock(self):
        self.lock = None
