# Defines the following variables:
# ArrayFire_INCLUDE_DIRS    - Location of ArrayFire's include directory.
# ArrayFire_LIBRARIES       - Location of ArrayFire's libraries. This will default
#                             to a GPU backend if one is found.
# ArrayFire_FOUND           - True if ArrayFire has been located
#
# You may provide a hint to where ArrayFire's root directory may be located
# by setting ArrayFire_DIR.
#
# ----------------------------------------------------------------------------
#
# ArrayFire_CPU_FOUND         - True of the ArrayFire CPU library has been found.
# ArrayFire_CPU_LIBRARIES     - Location of ArrayFire's CPU library, if found
# ArrayFire_CUDA_FOUND        - True of the ArrayFire CUDA library has been found.
# ArrayFire_CUDA_LIBRARIES    - Location of ArrayFire's CUDA library, if found
# ArrayFire_OpenCL_FOUND      - True of the ArrayFire OpenCL library has been found.
# ArrayFire_OpenCL_LIBRARIES  - Location of ArrayFire's OpenCL library, if found
# ArrayFire_Unified_FOUND     - True of the ArrayFire Unified library has been found.
# ArrayFire_Unified_LIBRARIES - Location of ArrayFire's Unified library, if found
#
#=============================================================================
# Copyright (c) 2015, ArrayFire
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without modification,
# are permitted provided that the following conditions are met:
#
# * Redistributions of source code must retain the above copyright notice, this
#   list of conditions and the following disclaimer.
#
# * Redistributions in binary form must reproduce the above copyright notice, this
#   list of conditions and the following disclaimer in the documentation and/or
#   other materials provided with the distribution.
#
# * Neither the name of the ArrayFire nor the names of its
#   contributors may be used to endorse or promote products derived from
#   this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#=============================================================================

get_filename_component(ArrayFire_INCLUDE_DIRS "${CMAKE_CURRENT_LIST_DIR}/../../../include" ABSOLUTE)

macro(find_backend backend libname)
  if (${backend} STREQUAL "Unified")
    set(targetFile ${CMAKE_CURRENT_LIST_DIR}//ArrayFire${backend}.cmake)
  else ()
    set(targetFile ${CMAKE_CURRENT_LIST_DIR}//ArrayFire${backend}.cmake)
  endif ()
  if(EXISTS ${targetFile})
    include(${targetFile})
    set(ArrayFire_${backend}_FOUND ON)
    set(ArrayFire_${backend}_LIBRARIES af${libname})
    # set the default backend
    set(ArrayFire_LIBRARIES af${libname})
  else()
    set(ArrayFire_${backend}_FOUND OFF)
  endif()
endmacro()

# keep in the backends in the slowest to fastest order
foreach(backend CPU OpenCL CUDA)
  string(TOLOWER "${backend}" lowerbackend)
  find_backend("${backend}" "${lowerbackend}")
endforeach()

find_backend("Unified" "")
