/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

abstract class SavingAction
extends AbstractRelationEditorAction {
    protected final TagEditorModel tagModel;
    protected final AutoCompletingTextField tfRole;

    protected SavingAction(MemberTable memberTable, MemberTableModel memberTableModel, TagEditorModel tagEditorModel, OsmDataLayer osmDataLayer, IRelationEditor iRelationEditor, AutoCompletingTextField autoCompletingTextField) {
        super(memberTable, memberTableModel, null, osmDataLayer, iRelationEditor);
        this.tagModel = tagEditorModel;
        this.tfRole = autoCompletingTextField;
    }

    protected void applyNewRelation(TagEditorModel tagEditorModel) {
        Relation relation = new Relation();
        tagEditorModel.applyToPrimitive(relation);
        this.memberTableModel.applyToRelation(relation);
        ArrayList<RelationMember> arrayList = new ArrayList<RelationMember>();
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.getMember().isDeleted()) continue;
            arrayList.add(relationMember);
        }
        if (relation.getMembersCount() != arrayList.size()) {
            relation.setMembers(arrayList);
            String string = I18n.tr("One or more members of this new relation have been deleted while the relation editor\nwas open. They have been removed from the relation members list.", new Object[0]);
            JOptionPane.showMessageDialog(Main.parent, string, I18n.tr("Warning", new Object[0]), 2);
        }
        if (relation.getMembersCount() == 0 && !relation.hasKeys()) {
            return;
        }
        Main.main.undoRedo.add(new AddCommand(this.layer, (OsmPrimitive)relation));
        this.layer.data.fireSelectionChanged();
        this.editor.setRelation(relation);
        if (this.editor instanceof RelationEditor) {
            RelationDialogManager.getRelationDialogManager().updateContext(this.layer, this.editor.getRelation(), (RelationEditor)this.editor);
        }
        SwingUtilities.invokeLater(() -> Main.map.relationListDialog.selectRelation(relation));
    }

    protected void applyExistingConflictingRelation(TagEditorModel tagEditorModel) {
        Relation relation = new Relation(this.editor.getRelation());
        tagEditorModel.applyToPrimitive(relation);
        this.memberTableModel.applyToRelation(relation);
        Conflict<Relation> conflict = new Conflict<Relation>(this.editor.getRelation(), relation);
        Main.main.undoRedo.add(new ConflictAddCommand(this.layer, conflict));
    }

    protected void applyExistingNonConflictingRelation(TagEditorModel tagEditorModel) {
        Relation relation = new Relation(this.editor.getRelation());
        tagEditorModel.applyToPrimitive(relation);
        this.memberTableModel.applyToRelation(relation);
        Main.main.undoRedo.add(new ChangeCommand(this.editor.getRelation(), relation));
        this.layer.data.fireSelectionChanged();
    }

    protected boolean confirmClosingBecauseOfDirtyState() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, create a conflict and close", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to create a conflict and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, continue editing", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        int n = HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>This relation has been changed outside of the editor.<br>You cannot apply your changes and continue editing.<br><br>Do you want to create a conflict and close the editor?</html>", new Object[0]), I18n.tr("Conflict in data", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], "/Dialog/RelationEditor#RelationChangedOutsideOfEditor");
        if (n == 0) {
            Main.map.conflictDialog.unfurlDialog();
        }
        return n == 0;
    }

    protected void warnDoubleConflict() {
        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Layer ''{0}'' already has a conflict for object<br>''{1}''.<br>Please resolve this conflict first, then try again.</html>", this.layer.getName(), this.editor.getRelation().getDisplayName(DefaultNameFormatter.getInstance())), I18n.tr("Double conflict", new Object[0]), 2);
    }

    @Override
    protected void updateEnabledState() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean applyChanges() {
        if (this.editor.getRelation() == null) {
            this.applyNewRelation(this.tagModel);
        } else if (this.isEditorDirty()) {
            if (this.editor.isDirtyRelation()) {
                if (!this.confirmClosingBecauseOfDirtyState()) return false;
                if (this.layer.getConflicts().hasConflictForMy(this.editor.getRelation())) {
                    this.warnDoubleConflict();
                    return false;
                }
                this.applyExistingConflictingRelation(this.tagModel);
                this.hideEditor();
            } else {
                this.applyExistingNonConflictingRelation(this.tagModel);
            }
        }
        this.editor.setRelation(this.editor.getRelation());
        return true;
    }

    protected void hideEditor() {
        if (this.editor instanceof Component) {
            ((Component)((Object)this.editor)).setVisible(false);
        }
    }

    protected boolean isEditorDirty() {
        Relation relation = this.editor.getRelationSnapshot();
        return relation != null && !this.memberTableModel.hasSameMembersAs(relation) || this.tagModel.isDirty();
    }
}

