/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class ValuePropertiesCollection
extends AbstractCollection<DebugValue> {
    private final Debugger debugger;
    private final RootNode sourceRoot;
    private final Set<Map.Entry<Object, Object>> entrySet;

    ValuePropertiesCollection(Debugger debugger, RootNode sourceRoot, Set<Map.Entry<Object, Object>> entrySet) {
        this.debugger = debugger;
        this.sourceRoot = sourceRoot;
        this.entrySet = entrySet;
    }

    @Override
    public Iterator<DebugValue> iterator() {
        return new PropertiesIterator(this.entrySet.iterator());
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    private final class PropertiesIterator
    implements Iterator<DebugValue> {
        private final Iterator<Map.Entry<Object, Object>> entries;

        PropertiesIterator(Iterator<Map.Entry<Object, Object>> entries) {
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public DebugValue next() {
            return new DebugValue.PropertyValue(ValuePropertiesCollection.this.debugger, ValuePropertiesCollection.this.sourceRoot, this.entries.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported.");
        }
    }
}

