/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.vm.LanguageCache;
import com.oracle.truffle.api.vm.ModuleResourceLocator;
import com.oracle.truffle.api.vm.PolyglotEngine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

final class InstrumentCache {
    static final boolean PRELOAD;
    private static final List<InstrumentCache> CACHE;
    private static List<InstrumentCache> cache;
    private Class<?> instrumentClass;
    private final String className;
    private final String id;
    private final String name;
    private final String version;
    private final ClassLoader loader;

    InstrumentCache(String prefix, Properties info, ClassLoader loader) {
        this.loader = loader;
        this.className = info.getProperty(prefix + "className");
        this.name = info.getProperty(prefix + "name");
        this.version = info.getProperty(prefix + "version");
        String loadedId = info.getProperty(prefix + "id");
        this.id = loadedId.equals("") ? this.className : loadedId;
    }

    static List<InstrumentCache> load() {
        if (PRELOAD) {
            return CACHE;
        }
        if (cache != null) {
            return cache;
        }
        ArrayList<InstrumentCache> list = new ArrayList<InstrumentCache>();
        HashSet<String> classNamesUsed = new HashSet<String>();
        for (ClassLoader loader : LanguageCache.AOT_LOADERS == null ? PolyglotEngine.Access.loaders() : LanguageCache.AOT_LOADERS) {
            InstrumentCache.loadForOne(loader, list, classNamesUsed);
        }
        if (!PolyglotEngine.JDK8OrEarlier) {
            InstrumentCache.loadForOne(ModuleResourceLocator.createLoader(), list, classNamesUsed);
        }
        cache = list;
        return cache;
    }

    private static void loadForOne(ClassLoader loader, List<InstrumentCache> list, Set<String> classNamesUsed) {
        Enumeration<URL> en;
        if (loader == null) {
            return;
        }
        try {
            en = loader.getResources("META-INF/truffle/instrument");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read list of Truffle instruments", ex);
        }
        while (en.hasMoreElements()) {
            String prefix;
            String className;
            Properties p;
            URL u = en.nextElement();
            try {
                p = new Properties();
                try (InputStream is = u.openStream();){
                    p.load(is);
                }
            }
            catch (IOException ex) {
                PolyglotEngine.LOG.log(Level.CONFIG, "Cannot process " + u + " as language definition", ex);
                continue;
            }
            int cnt = 1;
            while ((className = p.getProperty((prefix = "instrument" + cnt + ".") + "className")) != null) {
                if (!classNamesUsed.contains(className)) {
                    classNamesUsed.add(className);
                    list.add(new InstrumentCache(prefix, p, loader));
                }
                ++cnt;
            }
        }
        Collections.sort(list, new Comparator<InstrumentCache>(){

            @Override
            public int compare(InstrumentCache o1, InstrumentCache o2) {
                return o1.getId().compareTo(o2.getId());
            }
        });
    }

    String getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    String getVersion() {
        return this.version;
    }

    Class<?> getInstrumentationClass() {
        if (!PRELOAD && this.instrumentClass == null) {
            this.loadClass();
        }
        return this.instrumentClass;
    }

    private void loadClass() {
        try {
            this.instrumentClass = Class.forName(this.className, true, this.loader);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot initialize " + this.getName() + " instrument with implementation " + this.className, ex);
        }
    }

    static {
        List<InstrumentCache> instruments = null;
        if (Boolean.getBoolean("com.oracle.truffle.aot")) {
            instruments = InstrumentCache.load();
            for (InstrumentCache info : instruments) {
                info.loadClass();
            }
        }
        PRELOAD = (CACHE = instruments) != null;
    }
}

