/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import jnr.posix.SpawnFileAction;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.core.hash.KeyValue;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.platform.UnsafeGroup;

@CoreClass(value="Truffle::Process")
public abstract class TruffleProcessNodes {

    @CoreMethod(names={"spawn"}, onSingleton=true, required=4, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class SpawnNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(command)", "isRubyArray(arguments)", "isRubyArray(environmentVariables)", "isRubyHash(options)"})
        public int spawn(DynamicObject command, DynamicObject arguments, DynamicObject environmentVariables, DynamicObject options) {
            Collection<SpawnFileAction> fileActions = this.parseOptions(options);
            int pid = this.call(StringOperations.getString(command), this.toStringArray(arguments), this.toStringArray(environmentVariables), fileActions);
            if (pid == -1) {
                throw new RaiseException(this.coreExceptions().errnoError(this.getContext().getNativePlatform().getPosix().errno(), this));
            }
            return pid;
        }

        private String[] toStringArray(DynamicObject rubyStrings) {
            int size = Layouts.ARRAY.getSize(rubyStrings);
            Object[] unconvertedStrings = ArrayOperations.toObjectArray(rubyStrings);
            String[] strings = new String[size];
            for (int i = 0; i < size; ++i) {
                assert (Layouts.STRING.isString(unconvertedStrings[i]));
                strings[i] = StringOperations.getString((DynamicObject)unconvertedStrings[i]);
            }
            return strings;
        }

        @CompilerDirectives.TruffleBoundary
        private Collection<SpawnFileAction> parseOptions(DynamicObject options) {
            if (Layouts.HASH.getSize(options) == 0) {
                return Collections.emptyList();
            }
            ArrayList<SpawnFileAction> actions = new ArrayList<SpawnFileAction>();
            for (KeyValue keyValue : HashOperations.iterableKeyValues(options)) {
                Object key = keyValue.getKey();
                Object value = keyValue.getValue();
                if (Layouts.SYMBOL.isSymbol(key)) {
                    int i;
                    Object[] store;
                    int size;
                    DynamicObject array;
                    if (key == this.getSymbol("redirect_fd")) {
                        assert (Layouts.ARRAY.isArray(value));
                        array = (DynamicObject)value;
                        size = Layouts.ARRAY.getSize(array);
                        assert (size % 2 == 0);
                        store = ArrayOperations.toObjectArray(array);
                        for (i = 0; i < size; i += 2) {
                            int from = (Integer)store[i];
                            int to = (Integer)store[i + 1];
                            if (to < 0) {
                                to = -to - 1;
                            }
                            actions.add(SpawnFileAction.dup(to, from));
                        }
                        continue;
                    }
                    if (key == this.getSymbol("assign_fd")) {
                        assert (Layouts.ARRAY.isArray(value));
                        array = (DynamicObject)value;
                        size = Layouts.ARRAY.getSize(array);
                        assert (size % 4 == 0);
                        store = ArrayOperations.toObjectArray(array);
                        for (i = 0; i < size; i += 4) {
                            int fd = (Integer)store[i];
                            String path = StringOperations.getString((DynamicObject)store[i + 1]);
                            int flags = (Integer)store[i + 2];
                            int perms = (Integer)store[i + 3];
                            actions.add(SpawnFileAction.open(path, fd, flags, perms));
                        }
                        continue;
                    }
                }
                throw new UnsupportedOperationException("Unsupported spawn option: " + key + " => " + value);
            }
            return actions;
        }

        @CompilerDirectives.TruffleBoundary
        private int call(String command, String[] arguments, String[] environmentVariables, Collection<SpawnFileAction> fileActions) {
            return this.getContext().getNativePlatform().getPosix().posix_spawnp(command, fileActions, Arrays.asList(arguments), Arrays.asList(environmentVariables));
        }
    }
}

