/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayStrategy;

@CoreClass(value="Truffle::Array")
public class TruffleArrayNodes {

    @CoreMethod(names={"steal_storage"}, onSingleton=true, required=2)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class StealStorageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"array == other"})
        public DynamicObject stealStorageNoOp(DynamicObject array, DynamicObject other) {
            return array;
        }

        @Specialization(guards={"array != other", "strategy.matches(array)", "otherStrategy.matches(other)"}, limit="ARRAY_STRATEGIES")
        public DynamicObject stealStorage(DynamicObject array, DynamicObject other, @Cached(value="of(array)") ArrayStrategy strategy, @Cached(value="of(other)") ArrayStrategy otherStrategy) {
            int size = ArrayHelpers.getSize(other);
            Object store = ArrayHelpers.getStore(other);
            strategy.setStoreAndSize(array, store, size);
            otherStrategy.setStoreAndSize(other, null, 0);
            return array;
        }
    }
}

