/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format;

import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.control.RepeatExplodedNode;
import org.jruby.truffle.core.format.control.RepeatLoopNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.control.StarNode;

public class SharedTreeBuilder {
    private final RubyContext context;

    public SharedTreeBuilder(RubyContext context) {
        this.context = context;
    }

    public FormatNode finishSubSequence(Deque<List<FormatNode>> sequenceStack, int count) {
        List<FormatNode> sequence = sequenceStack.pop();
        SequenceNode sequenceNode = new SequenceNode(sequence.toArray(new FormatNode[sequence.size()]));
        if (count == -1) {
            return sequenceNode;
        }
        return this.createRepeatNode(count, sequenceNode);
    }

    public FormatNode applyCount(int count, FormatNode node) {
        switch (count) {
            case -1: {
                return node;
            }
            case -2: {
                return new StarNode(node);
            }
        }
        return this.createRepeatNode(count, node);
    }

    private FormatNode createRepeatNode(int count, FormatNode node) {
        if (count > this.context.getOptions().PACK_UNROLL_LIMIT) {
            return new RepeatLoopNode(count, node);
        }
        return new RepeatExplodedNode(count, node);
    }

    public StarLength parseCountContext(int count) {
        int length;
        boolean star;
        if (count == -1) {
            star = false;
            length = 1;
        } else if (count == -2) {
            star = true;
            length = 0;
        } else {
            star = false;
            length = count;
        }
        return new StarLength(star, length);
    }

    public static class StarLength {
        private final boolean star;
        private final int length;

        public StarLength(boolean star, int length) {
            this.star = star;
            this.length = length;
        }

        public boolean isStar() {
            return this.star;
        }

        public int getLength() {
            return this.length;
        }
    }
}

