/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.objectspace;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.objectspace.ObjectSpaceNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.language.objects.ObjectIDOperations;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;

@GeneratedBy(value=ObjectSpaceNodes.class)
public final class ObjectSpaceNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(ID2RefNodeFactory.getInstance(), EachObjectNodeFactory.getInstance(), DefineFinalizerNodeFactory.getInstance(), UndefineFinalizerNodeFactory.getInstance());
    }

    @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
    public static final class UndefineFinalizerNodeFactory
    implements NodeFactory<ObjectSpaceNodes.UndefineFinalizerNode> {
        private static UndefineFinalizerNodeFactory undefineFinalizerNodeFactoryInstance;

        private UndefineFinalizerNodeFactory() {
        }

        @Override
        public Class<ObjectSpaceNodes.UndefineFinalizerNode> getNodeClass() {
            return ObjectSpaceNodes.UndefineFinalizerNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ObjectSpaceNodes.UndefineFinalizerNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UndefineFinalizerNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.UndefineFinalizerNode> getInstance() {
            if (undefineFinalizerNodeFactoryInstance == null) {
                undefineFinalizerNodeFactoryInstance = new UndefineFinalizerNodeFactory();
            }
            return undefineFinalizerNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.UndefineFinalizerNode create(RubyNode[] arguments) {
            return new UndefineFinalizerNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
        public static final class UndefineFinalizerNodeGen
        extends ObjectSpaceNodes.UndefineFinalizerNode {
            @Node.Child
            private RubyNode arguments0_;

            private UndefineFinalizerNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return this.undefineFinalizer(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
    public static final class DefineFinalizerNodeFactory
    implements NodeFactory<ObjectSpaceNodes.DefineFinalizerNode> {
        private static DefineFinalizerNodeFactory defineFinalizerNodeFactoryInstance;

        private DefineFinalizerNodeFactory() {
        }

        @Override
        public Class<ObjectSpaceNodes.DefineFinalizerNode> getNodeClass() {
            return ObjectSpaceNodes.DefineFinalizerNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ObjectSpaceNodes.DefineFinalizerNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DefineFinalizerNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.DefineFinalizerNode> getInstance() {
            if (defineFinalizerNodeFactoryInstance == null) {
                defineFinalizerNodeFactoryInstance = new DefineFinalizerNodeFactory();
            }
            return defineFinalizerNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.DefineFinalizerNode create(RubyNode[] arguments) {
            return new DefineFinalizerNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
        public static final class DefineFinalizerNodeGen
        extends ObjectSpaceNodes.DefineFinalizerNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private DefineFinalizerNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="defineFinalizer(VirtualFrame, DynamicObject, Object, BranchProfile)", value=ObjectSpaceNodes.DefineFinalizerNode.class)
            private static final class DefineFinalizerNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;

                DefineFinalizerNode_(DefineFinalizerNodeGen root, BranchProfile errorProfile) {
                    super(root, 1);
                    this.errorProfile = errorProfile;
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        return this.root.defineFinalizer(frameValue, arguments0Value_, arguments1Value, this.errorProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DefineFinalizerNodeGen root, BranchProfile errorProfile) {
                    return new DefineFinalizerNode_(root, errorProfile);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DefineFinalizerNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(DefineFinalizerNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DefineFinalizerNodeGen root;

                BaseNode_(DefineFinalizerNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (DefineFinalizerNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        BranchProfile errorProfile1 = BranchProfile.create();
                        return DefineFinalizerNode_.create(this.root, errorProfile1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
    public static final class EachObjectNodeFactory
    implements NodeFactory<ObjectSpaceNodes.EachObjectNode> {
        private static EachObjectNodeFactory eachObjectNodeFactoryInstance;

        private EachObjectNodeFactory() {
        }

        @Override
        public Class<ObjectSpaceNodes.EachObjectNode> getNodeClass() {
            return ObjectSpaceNodes.EachObjectNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ObjectSpaceNodes.EachObjectNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachObjectNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.EachObjectNode> getInstance() {
            if (eachObjectNodeFactoryInstance == null) {
                eachObjectNodeFactoryInstance = new EachObjectNodeFactory();
            }
            return eachObjectNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.EachObjectNode create(RubyNode[] arguments) {
            return new EachObjectNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        public static final class EachObjectNodeGen
        extends ObjectSpaceNodes.EachObjectNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private BaseNode_ specialization_;

            private EachObjectNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="eachObject(VirtualFrame, DynamicObject, DynamicObject)", value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class EachObject1Node_
            extends BaseNode_ {
                EachObject1Node_(EachObjectNodeGen root) {
                    super(root, 2);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubyModule(arguments0Value_)) {
                        return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyModule(arguments0Value_)) {
                            return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new EachObject1Node_(root);
                }
            }

            @GeneratedBy(methodName="eachObject(VirtualFrame, NotProvided, DynamicObject)", value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class EachObject0Node_
            extends BaseNode_ {
                EachObject0Node_(EachObjectNodeGen root) {
                    super(root, 1);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    DynamicObject arguments1Value_;
                    NotProvided arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.root.arguments1_.execute(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        arguments1Value_ = this.root.arguments1_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof NotProvided && arguments1Value instanceof DynamicObject) {
                        NotProvided arguments0Value_ = (NotProvided)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        return this.root.eachObject(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new EachObject0Node_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EachObjectNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EachObjectNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EachObjectNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EachObjectNodeGen root;

                BaseNode_(EachObjectNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EachObjectNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_;
                        if (arguments0Value instanceof NotProvided) {
                            return EachObject0Node_.create(this.root);
                        }
                        if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyModule(arguments0Value_ = (DynamicObject)arguments0Value)) {
                            return EachObject1Node_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
    public static final class ID2RefNodeFactory
    implements NodeFactory<ObjectSpaceNodes.ID2RefNode> {
        private static ID2RefNodeFactory iD2RefNodeFactoryInstance;

        private ID2RefNodeFactory() {
        }

        @Override
        public Class<ObjectSpaceNodes.ID2RefNode> getNodeClass() {
            return ObjectSpaceNodes.ID2RefNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ObjectSpaceNodes.ID2RefNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ID2RefNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ObjectSpaceNodes.ID2RefNode> getInstance() {
            if (iD2RefNodeFactoryInstance == null) {
                iD2RefNodeFactoryInstance = new ID2RefNodeFactory();
            }
            return iD2RefNodeFactoryInstance;
        }

        public static ObjectSpaceNodes.ID2RefNode create(RubyNode[] arguments) {
            return new ID2RefNodeGen(arguments);
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ID2RefNodeGen
        extends ObjectSpaceNodes.ID2RefNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ID2RefNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
                if (value instanceof DynamicObject) {
                    return (DynamicObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="id2RefFloat(DynamicObject)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefFloatNode_
            extends BaseNode_ {
                Id2RefFloatNode_(ID2RefNodeGen root) {
                    super(root, 7);
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (RubyGuards.isRubyBignum(arguments0Value_) && this.root.isFloatID(arguments0Value_)) {
                        return this.root.id2RefFloat(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectDouble(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value) && this.root.isFloatID(arguments0Value_)) {
                        return this.root.id2RefFloat(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new Id2RefFloatNode_(root);
                }
            }

            @GeneratedBy(methodName="id2RefLargeFixnum(DynamicObject)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefLargeFixnumNode_
            extends BaseNode_ {
                Id2RefLargeFixnumNode_(ID2RefNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyBignum(arguments0Value_ = (DynamicObject)arguments0Value) && this.root.isLargeFixnumID(arguments0Value_)) {
                        return this.root.id2RefLargeFixnum(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new Id2RefLargeFixnumNode_(root);
                }
            }

            @GeneratedBy(methodName="id2Ref(long, ReadObjectFieldNode)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefNode_
            extends BaseNode_ {
                @Node.Child
                private ReadObjectFieldNode readObjectIdNode;
                private final Class<?> arguments0ImplicitType;

                Id2RefNode_(ID2RefNodeGen root, Object arguments0Value, ReadObjectFieldNode readObjectIdNode) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                    this.readObjectIdNode = readObjectIdNode;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (ObjectIDOperations.isBasicObjectID(arguments0Value_)) {
                        return this.root.id2Ref(arguments0Value_, this.readObjectIdNode);
                    }
                    return ID2RefNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && ObjectIDOperations.isBasicObjectID(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.id2Ref(arguments0Value_, this.readObjectIdNode);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value, ReadObjectFieldNode readObjectIdNode) {
                    return new Id2RefNode_(root, arguments0Value, readObjectIdNode);
                }
            }

            @GeneratedBy(methodName="id2RefSmallInt(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefSmallIntNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefSmallIntNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefSmallIntNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (ObjectIDOperations.isSmallFixnumID(arguments0Value_)) {
                        return this.root.id2RefSmallInt(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectLong(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && ObjectIDOperations.isSmallFixnumID(arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType))) {
                        return this.root.id2RefSmallInt(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefSmallIntNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="id2RefFalse(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefFalseNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefFalseNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 3);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefFalseNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ == 0L) {
                        return this.root.id2RefFalse(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 0L) {
                        return this.root.id2RefFalse(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefFalseNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="id2RefTrue(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefTrueNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefTrueNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 2);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefTrueNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    if (arguments0Value_ == 2L) {
                        return this.root.id2RefTrue(arguments0Value_);
                    }
                    return ID2RefNodeGen.expectBoolean(this.getNext().execute_(frameValue, arguments0Value_));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 2L) {
                        return this.root.id2RefTrue(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefTrueNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="id2RefNil(long)", value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class Id2RefNilNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Id2RefNilNode_(ID2RefNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Id2RefNilNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        arguments0Value_ = this.executeArguments0Long_(frameValue, this.arguments0ImplicitType);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    if (arguments0Value_ == 4L) {
                        return this.root.id2RefNil(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    long arguments0Value_;
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType) && (arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType)) == 4L) {
                        return this.root.id2RefNil(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root, Object arguments0Value) {
                    return new Id2RefNilNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ID2RefNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ID2RefNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(ID2RefNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ID2RefNodeGen root;

                BaseNode_(ID2RefNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ID2RefNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectDynamicObject(this.execute(frameValue));
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectBoolean(this.execute(frameValue));
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectDouble(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return ID2RefNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value);
                        if (arguments0Value_ == 4L) {
                            return Id2RefNilNode_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value_ == 2L) {
                            return Id2RefTrueNode_.create(this.root, arguments0Value);
                        }
                        if (arguments0Value_ == 0L) {
                            return Id2RefFalseNode_.create(this.root, arguments0Value);
                        }
                        if (ObjectIDOperations.isSmallFixnumID(arguments0Value_)) {
                            return Id2RefSmallIntNode_.create(this.root, arguments0Value);
                        }
                        if (ObjectIDOperations.isBasicObjectID(arguments0Value_)) {
                            ReadObjectFieldNode readObjectIdNode5 = this.root.createReadObjectIDNode();
                            return Id2RefNode_.create(this.root, arguments0Value, readObjectIdNode5);
                        }
                    }
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyBignum(arguments0Value_) && this.root.isLargeFixnumID(arguments0Value_)) {
                            return Id2RefLargeFixnumNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyBignum(arguments0Value_) && this.root.isFloatID(arguments0Value_)) {
                            return Id2RefFloatNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                protected final long executeArguments0Long_(Frame frameValue, Class<?> arguments0ImplicitType) throws UnexpectedResultException {
                    if (arguments0ImplicitType == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0ImplicitType == Integer.TYPE) {
                        return RubyTypes.promoteToLong(this.root.arguments0_.executeInteger((VirtualFrame)frameValue));
                    }
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return RubyTypesGen.expectImplicitLong(arguments0Value_, arguments0ImplicitType);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }
}

