/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import org.jcodings.Encoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LeafRope;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;

public class InvalidLeafRope
extends LeafRope {
    public InvalidLeafRope(byte[] bytes, Encoding encoding, int characterLength) {
        super(bytes, encoding, CodeRange.CR_BROKEN, false, characterLength);
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        int newCharacterLength = RopeOperations.strLength(newEncoding, this.getRawBytes(), 0, this.byteLength());
        return new InvalidLeafRope(this.getRawBytes(), newEncoding, newCharacterLength);
    }
}

