/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.interop.ForeignWriteNodeSubNodeGen;
import org.jruby.truffle.interop.RubyMessageResolution;

public abstract class ForeignWriteNodeSub
extends RubyMessageResolution.ForeignWriteNode {
    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, DynamicObject object, Object name, Object value) {
        return this.access(frame, object, name, value);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new WriteRootNode(language);
    }

    private static final class WriteRootNode
    extends RootNode {
        @Node.Child
        private ForeignWriteNodeSub node = ForeignWriteNodeSubNodeGen.create();

        protected WriteRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            Object identifier = ForeignAccess.getArguments(frame).get(0);
            Object value = ForeignAccess.getArguments(frame).get(1);
            try {
                return this.node.executeWithTarget(frame, receiver, identifier, value);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof ForeignWriteNodeSub) {
                    throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

