/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.exceptions.RescueNode;

public class RescueClassesNode
extends RescueNode {
    @Node.Children
    final RubyNode[] handlingClassNodes;

    public RescueClassesNode(RubyNode[] handlingClassNodes, RubyNode rescueBody) {
        super(rescueBody);
        this.handlingClassNodes = handlingClassNodes;
    }

    @Override
    @ExplodeLoop
    public boolean canHandle(VirtualFrame frame, DynamicObject exception) {
        for (RubyNode handlingClassNode : this.handlingClassNodes) {
            Object handlingClass = handlingClassNode.execute(frame);
            if (!this.matches(frame, exception, handlingClass)) continue;
            return true;
        }
        return false;
    }
}

