/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.parser.ArgumentDescriptor;
import org.jruby.truffle.parser.ArgumentType;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.OptArgParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RequiredKeywordArgumentValueParseNode;
import org.jruby.truffle.parser.ast.UnnamedRestArgParseNode;
import org.jruby.truffle.parser.ast.types.INameNode;

public class Helpers {
    public static final Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map = new HashMap<String, String>(keyValues.length / 2);
        int i = 0;
        while (i < keyValues.length) {
            map.put(keyValues[i++], keyValues[i++]);
        }
        return map;
    }

    public static ArgumentDescriptor[] argsNodeToArgumentDescriptors(ArgsParseNode argsNode) {
        int keywordsCount;
        int postCount;
        ArgumentParseNode restArg;
        int optCount;
        ArrayList<ArgumentDescriptor> descs = new ArrayList<ArgumentDescriptor>();
        ParseNode[] args = argsNode.getArgs();
        int preCount = argsNode.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                if (args[i] instanceof MultipleAsgnParseNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentParseNode)args[i]).getName()));
            }
        }
        if ((optCount = argsNode.getOptionalArgsCount()) > 0) {
            int optIndex = argsNode.getOptArgIndex();
            for (int i = 0; i < optCount; ++i) {
                ArgumentType type = ArgumentType.opt;
                ParseNode optNode = args[optIndex + i];
                String name = null;
                if (optNode instanceof OptArgParseNode) {
                    name = ((OptArgParseNode)optNode).getName();
                } else if (optNode instanceof LocalAsgnParseNode) {
                    name = ((LocalAsgnParseNode)optNode).getName();
                } else if (optNode instanceof DAsgnParseNode) {
                    name = ((DAsgnParseNode)optNode).getName();
                } else {
                    type = ArgumentType.anonopt;
                }
                descs.add(new ArgumentDescriptor(type, name));
            }
        }
        if ((restArg = argsNode.getRestArgNode()) != null) {
            if (restArg instanceof UnnamedRestArgParseNode) {
                if (((UnnamedRestArgParseNode)restArg).isStar()) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonrest));
                }
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.rest, restArg.getName()));
            }
        }
        if ((postCount = argsNode.getPostCount()) > 0) {
            int postIndex = argsNode.getPostIndex();
            for (int i = 0; i < postCount; ++i) {
                ParseNode postNode = args[postIndex + i];
                if (postNode instanceof MultipleAsgnParseNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentParseNode)postNode).getName()));
            }
        }
        if ((keywordsCount = argsNode.getKeywordCount()) > 0) {
            int keywordsIndex = argsNode.getKeywordsIndex();
            for (int i = 0; i < keywordsCount; ++i) {
                ParseNode keyWordNode = args[keywordsIndex + i];
                for (ParseNode asgnNode : keyWordNode.childNodes()) {
                    if (Helpers.isRequiredKeywordArgumentValueNode(asgnNode)) {
                        descs.add(new ArgumentDescriptor(ArgumentType.keyreq, ((INameNode)((Object)asgnNode)).getName()));
                        continue;
                    }
                    descs.add(new ArgumentDescriptor(ArgumentType.key, ((INameNode)((Object)asgnNode)).getName()));
                }
            }
        }
        if (argsNode.getKeyRest() != null) {
            String argName = argsNode.getKeyRest().getName();
            if (argName == null || argName.length() == 0) {
                descs.add(new ArgumentDescriptor(ArgumentType.anonkeyrest, argName));
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.keyrest, argsNode.getKeyRest().getName()));
            }
        }
        if (argsNode.getBlock() != null) {
            descs.add(new ArgumentDescriptor(ArgumentType.block, argsNode.getBlock().getName()));
        }
        return descs.toArray(new ArgumentDescriptor[descs.size()]);
    }

    public static boolean isRequiredKeywordArgumentValueNode(ParseNode asgnNode) {
        return asgnNode.childNodes().get(0) instanceof RequiredKeywordArgumentValueParseNode;
    }
}

