/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class RescueBodyParseNode
extends ParseNode {
    private final ParseNode exceptionNodes;
    private final ParseNode bodyNode;
    private final RescueBodyParseNode optRescueNode;

    public RescueBodyParseNode(SourceIndexLength position, ParseNode exceptionNodes, ParseNode bodyNode, RescueBodyParseNode optRescueNode) {
        super(position, exceptionNodes != null && exceptionNodes.containsVariableAssignment() || bodyNode.containsVariableAssignment() || optRescueNode != null && optRescueNode.containsVariableAssignment());
        assert (bodyNode != null) : "bodyNode is not null";
        this.exceptionNodes = exceptionNodes;
        this.bodyNode = bodyNode;
        this.optRescueNode = optRescueNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUEBODYNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitRescueBodyNode(this);
    }

    public ParseNode getBodyNode() {
        return this.bodyNode;
    }

    public RescueBodyParseNode getOptRescueNode() {
        return this.optRescueNode;
    }

    public ParseNode getExceptionNodes() {
        return this.exceptionNodes;
    }

    @Override
    public List<ParseNode> childNodes() {
        if (this.optRescueNode != null) {
            return ParseNode.createList(this.exceptionNodes, this.bodyNode, (ParseNode)this.optRescueNode);
        }
        return ParseNode.createList(this.exceptionNodes, this.bodyNode);
    }
}

