/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.parser;

import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.parser.scope.DynamicScope;
import org.jruby.truffle.parser.scope.StaticScope;

public class ParserConfiguration {
    private DynamicScope existingScope = null;
    private boolean asBlock = false;
    private int lineNumber = 0;
    private boolean inlineSource = false;
    private boolean isEvalParse = true;
    private boolean isDebug = false;
    private boolean saveData = false;
    private boolean frozenStringLiteral = false;
    private Encoding defaultEncoding;
    private RubyContext context;

    public ParserConfiguration(RubyContext context, int lineNumber, boolean inlineSource, boolean isFileParse, boolean saveData) {
        this.context = context;
        this.inlineSource = inlineSource;
        this.lineNumber = lineNumber;
        this.isEvalParse = !isFileParse;
        this.saveData = saveData;
    }

    public void setFrozenStringLiteral(boolean frozenStringLiteral) {
        this.frozenStringLiteral = frozenStringLiteral;
    }

    public boolean isFrozenStringLiteral() {
        return this.frozenStringLiteral;
    }

    public void setDefaultEncoding(Encoding encoding) {
        this.defaultEncoding = encoding;
    }

    public Encoding getDefaultEncoding() {
        if (this.defaultEncoding == null) {
            this.defaultEncoding = UTF8Encoding.INSTANCE;
        }
        return this.defaultEncoding;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public boolean isEvalParse() {
        return this.isEvalParse;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void parseAsBlock(DynamicScope existingScope) {
        this.asBlock = true;
        this.existingScope = existingScope;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public DynamicScope getScope(String file) {
        if (this.asBlock) {
            return this.existingScope;
        }
        return new DynamicScope(new StaticScope(StaticScope.Type.LOCAL, (StaticScope)null, file), this.existingScope);
    }

    public boolean isCoverageEnabled() {
        return !this.isEvalParse();
    }

    public boolean isSaveData() {
        return this.saveData;
    }

    public boolean isInlineSource() {
        return this.inlineSource;
    }
}

