/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.readline;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;
import org.jruby.truffle.stdlib.readline.ReadlineHistoryNodes;

@GeneratedBy(value=ReadlineHistoryNodes.class)
public final class ReadlineHistoryNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(PushNodeFactory.getInstance(), PopNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), LengthNodeFactory.getInstance(), ClearNodeFactory.getInstance(), EachNodeFactory.getInstance(), GetIndexNodeFactory.getInstance(), SetIndexNodeFactory.getInstance(), DeleteAtNodeFactory.getInstance());
    }

    @GeneratedBy(value=ReadlineHistoryNodes.DeleteAtNode.class)
    public static final class DeleteAtNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.DeleteAtNode> {
        private static DeleteAtNodeFactory deleteAtNodeFactoryInstance;

        private DeleteAtNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.DeleteAtNode> getNodeClass() {
            return ReadlineHistoryNodes.DeleteAtNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.DeleteAtNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DeleteAtNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.DeleteAtNode> getInstance() {
            if (deleteAtNodeFactoryInstance == null) {
                deleteAtNodeFactoryInstance = new DeleteAtNodeFactory();
            }
            return deleteAtNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.DeleteAtNode create(RubyNode[] arguments) {
            return new DeleteAtNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.DeleteAtNode.class)
        public static final class DeleteAtNodeGen
        extends ReadlineHistoryNodes.DeleteAtNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private DeleteAtNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="deleteAt(int)", value=ReadlineHistoryNodes.DeleteAtNode.class)
            private static final class DeleteAtNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                DeleteAtNode_(DeleteAtNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((DeleteAtNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.deleteAt(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.deleteAt(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DeleteAtNodeGen root, Object arguments0Value) {
                    return new DeleteAtNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.DeleteAtNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(DeleteAtNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.DeleteAtNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(DeleteAtNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(DeleteAtNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.DeleteAtNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected DeleteAtNodeGen root;

                BaseNode_(DeleteAtNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (DeleteAtNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return DeleteAtNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.SetIndexNode.class)
    public static final class SetIndexNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.SetIndexNode> {
        private static SetIndexNodeFactory setIndexNodeFactoryInstance;

        private SetIndexNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.SetIndexNode> getNodeClass() {
            return ReadlineHistoryNodes.SetIndexNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        @Override
        public ReadlineHistoryNodes.SetIndexNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return SetIndexNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.SetIndexNode> getInstance() {
            if (setIndexNodeFactoryInstance == null) {
                setIndexNodeFactoryInstance = new SetIndexNodeFactory();
            }
            return setIndexNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.SetIndexNode create(RubyNode index, RubyNode line) {
            return new SetIndexNodeGen(index, line);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.SetIndexNode.class)
        public static final class SetIndexNodeGen
        extends ReadlineHistoryNodes.SetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode index_;
            @Node.Child
            private RubyNode line_;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexType_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetIndexNodeGen(RubyNode index, RubyNode line) {
                this.index_ = this.coerceIndexToInt(index);
                this.line_ = this.coerceLineToJavaString(line);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static String expectString(Object value) throws UnexpectedResultException {
                if (value instanceof String) {
                    return (String)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="setIndex(int, String)", value=ReadlineHistoryNodes.SetIndexNode.class)
            private static final class SetIndexNode_
            extends BaseNode_ {
                private final Class<?> indexImplicitType;

                SetIndexNode_(SetIndexNodeGen root, Object indexValue) {
                    super(root, 1);
                    this.indexImplicitType = RubyTypesGen.getImplicitIntegerClass(indexValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.indexImplicitType == ((SetIndexNode_)other).indexImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    String lineValue_;
                    int indexValue_;
                    try {
                        if (this.indexImplicitType == Integer.TYPE) {
                            indexValue_ = this.root.index_.executeInteger(frameValue);
                        } else {
                            Object indexValue__ = this.executeIndex_(frameValue);
                            indexValue_ = RubyTypesGen.expectImplicitInteger(indexValue__, this.indexImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object lineValue = this.root.line_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), lineValue);
                    }
                    try {
                        lineValue_ = SetIndexNodeGen.expectString(this.root.line_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, indexValue_, ex.getResult());
                    }
                    return this.root.setIndex(indexValue_, lineValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object indexValue, Object lineValue) {
                    if (RubyTypesGen.isImplicitInteger(indexValue, this.indexImplicitType) && lineValue instanceof String) {
                        int indexValue_ = RubyTypesGen.asImplicitInteger(indexValue, this.indexImplicitType);
                        String lineValue_ = (String)lineValue;
                        return this.root.setIndex(indexValue_, lineValue_);
                    }
                    return this.getNext().execute_(frameValue, indexValue, lineValue);
                }

                static BaseNode_ create(SetIndexNodeGen root, Object indexValue) {
                    return new SetIndexNode_(root, indexValue);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.SetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetIndexNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object indexValue, Object lineValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, indexValue, lineValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object indexValue, Object lineValue) {
                    return this.getNext().execute_(frameValue, indexValue, lineValue);
                }

                static BaseNode_ create(SetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.SetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object indexValue, Object lineValue) {
                    return this.uninitialized((Frame)frameValue, indexValue, lineValue);
                }

                static BaseNode_ create(SetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.SetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetIndexNodeGen root;

                BaseNode_(SetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetIndexNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.index_, this.root.line_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object indexValue, Object lineValue) {
                    return this.execute_((VirtualFrame)frameValue, indexValue, lineValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object indexValue_ = this.executeIndex_(frameValue);
                    Object lineValue_ = this.root.line_.execute(frameValue);
                    return this.execute_(frameValue, indexValue_, lineValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object indexValue, Object lineValue) {
                    if (RubyTypesGen.isImplicitInteger(indexValue) && lineValue instanceof String) {
                        return SetIndexNode_.create(this.root, indexValue);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeIndex_(Frame frameValue) {
                    Object object;
                    Class indexType_ = this.root.indexType_;
                    if (indexType_ == Integer.TYPE) {
                        return this.root.index_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (indexType_ != null) return this.root.index_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.index_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.indexType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.indexType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.indexType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.GetIndexNode> getNodeClass() {
            return ReadlineHistoryNodes.GetIndexNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.GetIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.GetIndexNode create(RubyNode[] arguments) {
            return new GetIndexNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.GetIndexNode.class)
        public static final class GetIndexNodeGen
        extends ReadlineHistoryNodes.GetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetIndexNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="getIndex(int)", value=ReadlineHistoryNodes.GetIndexNode.class)
            private static final class GetIndexNode_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                GetIndexNode_(GetIndexNodeGen root, Object arguments0Value) {
                    super(root, 1);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((GetIndexNode_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, ex.getResult());
                    }
                    return this.root.getIndex(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.getIndex(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, Object arguments0Value) {
                    return new GetIndexNode_(root, arguments0Value);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.GetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetIndexNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.GetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ReadlineHistoryNodes.GetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetIndexNodeGen root;

                BaseNode_(GetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (GetIndexNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return GetIndexNode_.create(this.root, arguments0Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.EachNode.class)
    public static final class EachNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.EachNode> getNodeClass() {
            return ReadlineHistoryNodes.EachNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.EachNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EachNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.EachNode create(RubyNode[] arguments) {
            return new EachNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.EachNode.class)
        public static final class EachNodeGen
        extends ReadlineHistoryNodes.EachNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EachNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.each(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.ClearNode.class)
    public static final class ClearNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.ClearNode> getNodeClass() {
            return ReadlineHistoryNodes.ClearNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.ClearNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ClearNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.ClearNode create(RubyNode[] arguments) {
            return new ClearNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends ReadlineHistoryNodes.ClearNode {
            private ClearNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.clear();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.LengthNode.class)
    public static final class LengthNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.LengthNode> {
        private static LengthNodeFactory lengthNodeFactoryInstance;

        private LengthNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.LengthNode> getNodeClass() {
            return ReadlineHistoryNodes.LengthNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.LengthNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LengthNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.LengthNode> getInstance() {
            if (lengthNodeFactoryInstance == null) {
                lengthNodeFactoryInstance = new LengthNodeFactory();
            }
            return lengthNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.LengthNode create(RubyNode[] arguments) {
            return new LengthNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.LengthNode.class)
        public static final class LengthNodeGen
        extends ReadlineHistoryNodes.LengthNode {
            private LengthNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.length();
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.ShiftNode> getNodeClass() {
            return ReadlineHistoryNodes.ShiftNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.ShiftNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ShiftNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.ShiftNode create(RubyNode[] arguments) {
            return new ShiftNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.ShiftNode.class)
        public static final class ShiftNodeGen
        extends ReadlineHistoryNodes.ShiftNode {
            private ShiftNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.shift();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.PopNode.class)
    public static final class PopNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.PopNode> getNodeClass() {
            return ReadlineHistoryNodes.PopNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.PopNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PopNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.PopNode create(RubyNode[] arguments) {
            return new PopNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.PopNode.class)
        public static final class PopNodeGen
        extends ReadlineHistoryNodes.PopNode {
            private PopNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.pop();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=ReadlineHistoryNodes.PushNode.class)
    public static final class PushNodeFactory
    implements NodeFactory<ReadlineHistoryNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
        }

        @Override
        public Class<ReadlineHistoryNodes.PushNode> getNodeClass() {
            return ReadlineHistoryNodes.PushNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ReadlineHistoryNodes.PushNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PushNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ReadlineHistoryNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        public static ReadlineHistoryNodes.PushNode create(RubyNode[] arguments) {
            return new PushNodeGen(arguments);
        }

        @GeneratedBy(value=ReadlineHistoryNodes.PushNode.class)
        public static final class PushNodeGen
        extends ReadlineHistoryNodes.PushNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PushNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = this.arguments1_.executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                return this.push(frameValue, arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }
        }
    }
}

