/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.concurrent.atomic.AtomicLong;

public final class StreamDumper
extends Thread {
    private final BufferedReader in;
    private final PrintStream out;
    private final AtomicLong endTime;

    @Override
    public final void run() {
        StreamDumper streamDumper = this;
        while (streamDumper.endTime.get() > System.currentTimeMillis()) {
            String string = streamDumper.in.readLine();
            if (string == null) {
                break;
            }
            streamDumper.out.println(string);
            streamDumper.out.flush();
        }
        this.out.close();
    }

    public final void close(boolean bl) {
        if (bl) {
            this.endTime.set(System.currentTimeMillis() + 5000L);
            Thread.yield();
            while (this.isAlive() && this.endTime.get() > System.currentTimeMillis()) {
                Thread.sleep(50L);
            }
        } else {
            this.endTime.set(System.currentTimeMillis());
        }
    }

    public StreamDumper(BufferedReader bufferedReader, PrintStream printStream) {
        this.in = bufferedReader;
        this.out = printStream;
        this.setDaemon(true);
        this.endTime = new AtomicLong(Long.MAX_VALUE);
    }
}

