/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.parosproxy.paros.Constant;

public class AlertRiskTableCellItem
implements Comparable<AlertRiskTableCellItem> {
    private static final Map<Integer, AlertRiskTableCellItem> values;
    public static final AlertRiskTableCellItem NO_RISK_CELL_ITEM;
    public static final AlertRiskTableCellItem UNDEFINED_RISK_CELL_ITEM;
    private final int risk;
    private final String description;

    private AlertRiskTableCellItem(int n, String string) {
        this.risk = n;
        this.description = string;
    }

    public int getRisk() {
        return this.risk;
    }

    public int hashCode() {
        return 31 + this.risk;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AlertRiskTableCellItem alertRiskTableCellItem = (AlertRiskTableCellItem)object;
        return this.risk == alertRiskTableCellItem.risk;
    }

    @Override
    public int compareTo(AlertRiskTableCellItem alertRiskTableCellItem) {
        int n = alertRiskTableCellItem.risk;
        if (this.risk < n) {
            return -1;
        }
        if (this.risk > n) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.description;
    }

    public static AlertRiskTableCellItem getItemForRisk(int n) {
        if (n == -1) {
            return NO_RISK_CELL_ITEM;
        }
        AlertRiskTableCellItem alertRiskTableCellItem = values.get(n);
        if (alertRiskTableCellItem == null) {
            return UNDEFINED_RISK_CELL_ITEM;
        }
        return alertRiskTableCellItem;
    }

    static {
        HashMap<Integer, AlertRiskTableCellItem> hashMap = new HashMap<Integer, AlertRiskTableCellItem>();
        AlertRiskTableCellItem alertRiskTableCellItem = new AlertRiskTableCellItem(0, Constant.messages.getString("view.href.table.cell.alert.risk.label.info"));
        hashMap.put(alertRiskTableCellItem.getRisk(), alertRiskTableCellItem);
        alertRiskTableCellItem = new AlertRiskTableCellItem(1, Constant.messages.getString("view.href.table.cell.alert.risk.label.low"));
        hashMap.put(alertRiskTableCellItem.getRisk(), alertRiskTableCellItem);
        alertRiskTableCellItem = new AlertRiskTableCellItem(2, Constant.messages.getString("view.href.table.cell.alert.risk.label.medium"));
        hashMap.put(alertRiskTableCellItem.getRisk(), alertRiskTableCellItem);
        alertRiskTableCellItem = new AlertRiskTableCellItem(3, Constant.messages.getString("view.href.table.cell.alert.risk.label.high"));
        hashMap.put(alertRiskTableCellItem.getRisk(), alertRiskTableCellItem);
        values = Collections.unmodifiableMap(hashMap);
        NO_RISK_CELL_ITEM = new AlertRiskTableCellItem(-1, "");
        UNDEFINED_RISK_CELL_ITEM = new AlertRiskTableCellItem(-2, Constant.messages.getString("view.href.table.cell.alert.risk.label.undefined"));
    }
}

