/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugStackFrame;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SteppingStrategy;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SuspendedEvent {
    private final SourceSection sourceSection;
    private final DebuggerSession.SteppingLocation location;
    private final Thread thread;
    private DebuggerSession session;
    private EventContext context;
    private MaterializedFrame materializedFrame;
    private List<Breakpoint> breakpoints;
    private Object returnValue;
    private volatile boolean disposed;
    private volatile SteppingStrategy nextStrategy;
    private Map<Breakpoint, Throwable> conditionFailures;
    private DebugStackFrameIterable cachedFrames;

    SuspendedEvent(DebuggerSession session, Thread thread, EventContext context, MaterializedFrame frame, DebuggerSession.SteppingLocation location, Object returnValue, List<Breakpoint> breakpoints, Map<Breakpoint, Throwable> conditionFailures) {
        this.session = session;
        this.context = context;
        this.location = location;
        this.materializedFrame = frame;
        this.returnValue = returnValue;
        this.conditionFailures = conditionFailures;
        this.breakpoints = breakpoints == null ? Collections.emptyList() : Collections.unmodifiableList(breakpoints);
        this.thread = thread;
        this.sourceSection = context.getInstrumentedSourceSection();
    }

    boolean isDisposed() {
        return this.disposed;
    }

    void clearLeakingReferences() {
        this.disposed = true;
        this.returnValue = null;
        this.breakpoints = null;
        this.materializedFrame = null;
        this.cachedFrames = null;
        this.session = null;
        this.context = null;
    }

    void verifyValidState(boolean allowDifferentThread) {
        if (this.disposed) {
            throw new IllegalStateException("Not in a suspended state.");
        }
        if (!allowDifferentThread && Thread.currentThread() != this.thread) {
            throw new IllegalStateException("Illegal thread access.");
        }
    }

    SteppingStrategy getNextStrategy() {
        SteppingStrategy strategy = this.nextStrategy;
        if (strategy == null) {
            return SteppingStrategy.createContinue();
        }
        return strategy;
    }

    private void setNextStrategy(SteppingStrategy nextStrategy) {
        this.verifyValidState(true);
        this.nextStrategy = nextStrategy;
    }

    public DebuggerSession getSession() {
        this.verifyValidState(true);
        return this.session;
    }

    Thread getThread() {
        return this.thread;
    }

    EventContext getContext() {
        return this.context;
    }

    DebuggerSession.SteppingLocation getLocation() {
        return this.location;
    }

    @Deprecated
    public Debugger getDebugger() {
        this.verifyValidState(true);
        return this.session.getDebugger();
    }

    @Deprecated
    public Node getNode() {
        return this.context.getInstrumentedNode();
    }

    public SourceSection getSourceSection() {
        this.verifyValidState(true);
        return this.sourceSection;
    }

    public boolean isHaltedBefore() {
        this.verifyValidState(true);
        return this.location == DebuggerSession.SteppingLocation.BEFORE_STATEMENT;
    }

    public DebugValue getReturnValue() {
        return this.getTopStackFrame().wrapHeapValue(this.returnValue);
    }

    @Deprecated
    public MaterializedFrame getFrame() {
        return this.materializedFrame;
    }

    MaterializedFrame getMaterializedFrame() {
        return this.materializedFrame;
    }

    @Deprecated
    public List<String> getRecentWarnings() {
        this.verifyValidState(false);
        ArrayList<String> list = new ArrayList<String>();
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            Throwable failure = this.getBreakpointConditionException(breakpoint);
            if (failure == null) continue;
            list.add(String.format("Exception in %s:  %s", breakpoint.toString(), failure.toString()));
        }
        return Collections.emptyList();
    }

    public Throwable getBreakpointConditionException(Breakpoint breakpoint) {
        this.verifyValidState(true);
        if (this.conditionFailures == null) {
            return null;
        }
        return this.conditionFailures.get(breakpoint);
    }

    public List<Breakpoint> getBreakpoints() {
        this.verifyValidState(true);
        return this.breakpoints;
    }

    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public List<FrameInstance> getStack() {
        this.verifyValidState(false);
        final ArrayList<FrameInstance> frameInstances = new ArrayList<FrameInstance>();
        Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){

            @Override
            public FrameInstance visitFrame(FrameInstance frameInstance) {
                if (SuspendedEvent.isEvalRootStackFrame(SuspendedEvent.this, frameInstance)) {
                    return frameInstance;
                }
                frameInstances.add(frameInstance);
                return null;
            }
        });
        return frameInstances;
    }

    public DebugStackFrame getTopStackFrame() {
        return this.getStackFrames().iterator().next();
    }

    public Iterable<DebugStackFrame> getStackFrames() {
        this.verifyValidState(false);
        if (this.cachedFrames == null) {
            this.cachedFrames = new DebugStackFrameIterable();
        }
        return this.cachedFrames;
    }

    private static boolean isEvalRootStackFrame(SuspendedEvent event, FrameInstance instance) {
        CallTarget target = instance.getCallTarget();
        RootNode root = null;
        if (target instanceof RootCallTarget) {
            root = ((RootCallTarget)target).getRootNode();
        }
        return root != null && event.getSession().getDebugger().getEnv().isEngineRoot(root);
    }

    public void prepareContinue() {
        this.setNextStrategy(SteppingStrategy.createContinue());
    }

    public void prepareStepInto(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException("stepCount must be > 0");
        }
        this.setNextStrategy(SteppingStrategy.createStepInto(stepCount));
    }

    public void prepareStepOut() {
        this.setNextStrategy(SteppingStrategy.createStepOut());
    }

    public void prepareStepOver(int stepCount) {
        if (stepCount <= 0) {
            throw new IllegalArgumentException("stepCount must be > 0");
        }
        this.setNextStrategy(SteppingStrategy.createStepOver(stepCount));
    }

    public void prepareKill() {
        this.setNextStrategy(SteppingStrategy.createKill());
    }

    @Deprecated
    public Object eval(String code, FrameInstance frameInstance) throws IOException {
        this.verifyValidState(false);
        return DebuggerSession.evalInContext(this, code, frameInstance);
    }

    @Deprecated
    public String toString(Object value, FrameInstance frameInstance) {
        this.verifyValidState(false);
        RootNode rootNode = null;
        if (frameInstance.getCallTarget() instanceof RootCallTarget) {
            rootNode = ((RootCallTarget)frameInstance.getCallTarget()).getRootNode();
        }
        if (rootNode == null) {
            return value.toString();
        }
        return this.session.getDebugger().getEnv().toString(rootNode, value);
    }

    public String toString() {
        return "Suspended at " + this.getSourceSection() + " for thread " + this.getThread();
    }

    private final class DebugStackFrameIterable
    implements Iterable<DebugStackFrame> {
        private DebugStackFrame topStackFrame;
        private List<DebugStackFrame> otherFrames;

        private DebugStackFrameIterable() {
        }

        private DebugStackFrame getTopStackFrame() {
            if (this.topStackFrame == null) {
                this.topStackFrame = new DebugStackFrame(SuspendedEvent.this, null);
            }
            return this.topStackFrame;
        }

        private List<DebugStackFrame> getOtherFrames() {
            if (this.otherFrames == null) {
                final ArrayList<DebugStackFrame> frameInstances = new ArrayList<DebugStackFrame>();
                Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<FrameInstance>(){
                    private boolean first = true;

                    @Override
                    public FrameInstance visitFrame(FrameInstance frameInstance) {
                        if (SuspendedEvent.isEvalRootStackFrame(SuspendedEvent.this, frameInstance)) {
                            return frameInstance;
                        }
                        if (this.first) {
                            this.first = false;
                            return null;
                        }
                        frameInstances.add(new DebugStackFrame(SuspendedEvent.this, frameInstance));
                        return null;
                    }
                });
                this.otherFrames = frameInstances;
            }
            return this.otherFrames;
        }

        @Override
        public Iterator<DebugStackFrame> iterator() {
            return new Iterator<DebugStackFrame>(){
                private int index;
                private Iterator<DebugStackFrame> otherIterator;

                @Override
                public boolean hasNext() {
                    SuspendedEvent.this.verifyValidState(false);
                    if (this.index == 0) {
                        return true;
                    }
                    return this.getOtherStackFrames().hasNext();
                }

                @Override
                public DebugStackFrame next() {
                    SuspendedEvent.this.verifyValidState(false);
                    if (this.index == 0) {
                        ++this.index;
                        return DebugStackFrameIterable.this.getTopStackFrame();
                    }
                    return this.getOtherStackFrames().next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                private Iterator<DebugStackFrame> getOtherStackFrames() {
                    if (this.otherIterator == null) {
                        this.otherIterator = DebugStackFrameIterable.this.getOtherFrames().iterator();
                    }
                    return this.otherIterator;
                }
            };
        }
    }
}

