/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.kernel;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.debug.DebugHelpers;
import org.jruby.truffle.language.backtrace.Backtrace;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.control.RaiseException;

public class AtExitManager {
    private final RubyContext context;
    private final Deque<DynamicObject> atExitHooks = new ConcurrentLinkedDeque<DynamicObject>();
    private final Deque<DynamicObject> systemExitHooks = new ConcurrentLinkedDeque<DynamicObject>();

    public AtExitManager(RubyContext context) {
        this.context = context;
    }

    public void add(DynamicObject block, boolean always) {
        if (always) {
            this.systemExitHooks.push(block);
        } else {
            this.atExitHooks.push(block);
        }
    }

    public DynamicObject runAtExitHooks() {
        return this.runExitHooks(this.atExitHooks);
    }

    public void runSystemExitHooks() {
        this.runExitHooks(this.systemExitHooks);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject runExitHooks(Deque<DynamicObject> stack) {
        DynamicObject lastException = null;
        while (true) {
            DynamicObject block;
            try {
                block = stack.pop();
            }
            catch (NoSuchElementException e) {
                return lastException;
            }
            try {
                ProcOperations.rootCall(block, new Object[0]);
                continue;
            }
            catch (RaiseException e) {
                lastException = AtExitManager.handleAtExitException(this.context, e);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public List<DynamicObject> getHandlers() {
        ArrayList<DynamicObject> handlers = new ArrayList<DynamicObject>();
        handlers.addAll(this.atExitHooks);
        handlers.addAll(this.systemExitHooks);
        return handlers;
    }

    public static DynamicObject handleAtExitException(RubyContext context, RaiseException raiseException) {
        DynamicObject rubyException = raiseException.getException();
        if (Layouts.BASIC_OBJECT.getLogicalClass(rubyException) != context.getCoreLibrary().getSystemExitClass()) {
            Backtrace backtrace = Layouts.EXCEPTION.getBacktrace(rubyException);
            if (backtrace != null) {
                BacktraceFormatter.createDefaultFormatter(context).printBacktrace(context, rubyException, backtrace);
            } else {
                String code = "puts format \"%s: %s (%s)\\n%s\", e.backtrace[0], e.message, e.class, e.backtrace[1..-1].map { |l| \"\\tfrom \" + l }.join(\"\\n\")";
                DebugHelpers.eval(context, "puts format \"%s: %s (%s)\\n%s\", e.backtrace[0], e.message, e.class, e.backtrace[1..-1].map { |l| \"\\tfrom \" + l }.join(\"\\n\")", "e", rubyException);
            }
        }
        return rubyException;
    }
}

