/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ParserByteList;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.SideEffectFree;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.types.INameNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class SymbolParseNode
extends ParseNode
implements ILiteralNode,
INameNode,
SideEffectFree {
    private final String name;
    private final Encoding encoding;

    public SymbolParseNode(SourceIndexLength position, String name, Encoding encoding, CodeRange cr) {
        super(position, false);
        this.name = name;
        this.encoding = encoding == USASCIIEncoding.INSTANCE || cr == CodeRange.CR_7BIT ? USASCIIEncoding.INSTANCE : encoding;
    }

    public SymbolParseNode(SourceIndexLength position, ParserByteList value) {
        super(position, false);
        this.name = value.toString().intern();
        if (value.getEncoding() != USASCIIEncoding.INSTANCE) {
            int size = value.getLength();
            this.encoding = value.getStringLength() == size ? USASCIIEncoding.INSTANCE : value.getEncoding();
        } else {
            this.encoding = USASCIIEncoding.INSTANCE;
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SYMBOLNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }
}

