/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.posix;

import com.kenai.jffi.Platform;
import com.oracle.truffle.api.CompilerDirectives;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.util.Collection;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.Signal;
import jnr.constants.platform.Sysconf;
import jnr.ffi.Pointer;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.Passwd;
import jnr.posix.SignalHandler;
import jnr.posix.SpawnFileAction;
import jnr.posix.Times;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.platform.posix.TrufflePosix;

public class JNRTrufflePosix
implements TrufflePosix {
    private final POSIX posix;

    public JNRTrufflePosix(POSIX posix) {
        this.posix = posix;
    }

    protected POSIX getPosix() {
        return this.posix;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public byte[] crypt(byte[] key, byte[] salt) {
        return this.posix.crypt(key, salt);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public FileStat allocateStat() {
        return this.posix.allocateStat();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int chmod(String filename, int mode) {
        return this.posix.chmod(filename, mode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fchmod(int fd, int mode) {
        return this.posix.fchmod(fd, mode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int chown(String filename, int user, int group) {
        return this.posix.chown(filename, user, group);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fchown(int fd, int user, int group) {
        return this.posix.fchown(fd, user, group);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int exec(String path, String ... argv) {
        return this.posix.execv(path, argv);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int exec(String path, String[] argv, String[] envp) {
        return this.posix.execve(path, argv, envp);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fork() {
        return this.posix.fork();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fstat(int fd, FileStat stat) {
        return this.posix.fstat(fd, stat);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getenv(String envName) {
        return this.posix.getenv(envName);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getegid() {
        return this.posix.getegid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int geteuid() {
        return this.posix.geteuid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int seteuid(int euid) {
        return this.posix.seteuid(euid);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getgid() {
        return this.posix.getgid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getpgid(int pid) {
        return this.posix.getpgid(pid);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setpgid(int pid, int pgid) {
        return this.posix.setpgid(pid, pgid);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getpgrp() {
        return this.posix.getpgrp();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getpid() {
        return this.posix.getpid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getppid() {
        return this.posix.getppid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getpriority(int which, int who) {
        this.posix.errno(0);
        return this.posix.getpriority(which, who);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Passwd getpwnam(String which) {
        return this.posix.getpwnam(which);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getuid() {
        return this.posix.getuid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getrlimit(int resource, Pointer rlim) {
        return this.posix.getrlimit(resource, rlim);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setrlimit(int resource, Pointer rlim) {
        return this.posix.setrlimit(resource, rlim);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean isatty(FileDescriptor descriptor) {
        return this.posix.isatty(descriptor);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int kill(int pid, int signal) {
        return this.posix.kill(pid, signal);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int kill(long pid, int signal) {
        return this.posix.kill(pid, signal);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public SignalHandler signal(Signal sig, SignalHandler handler) {
        return this.posix.signal(sig, handler);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int lchmod(String filename, int mode) {
        return this.posix.lchmod(filename, mode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int link(String oldpath, String newpath) {
        return this.posix.link(oldpath, newpath);
    }

    @CompilerDirectives.TruffleBoundary
    public FileStat lstat(String path) {
        return this.posix.lstat(path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int lstat(String path, FileStat stat) {
        return this.posix.lstat(path, stat);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int mkdir(String path, int mode) {
        return this.posix.mkdir(path, mode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int readlink(CharSequence path, Pointer bufPtr, int bufsize) {
        return this.posix.readlink(path, bufPtr, bufsize);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int rmdir(String path) {
        return this.posix.rmdir(path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setenv(String envName, String envValue, int overwrite) {
        return this.posix.setenv(envName, envValue, overwrite);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setsid() {
        return this.posix.setsid();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setgid(int gid) {
        return this.posix.setgid(gid);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setpriority(int which, int who, int prio) {
        return this.posix.setpriority(which, who, prio);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int setuid(int uid) {
        return this.posix.setuid(uid);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public FileStat stat(String path) {
        return this.posix.stat(path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int stat(String path, FileStat stat) {
        return this.posix.stat(path, stat);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int symlink(String oldpath, String newpath) {
        return this.posix.symlink(oldpath, newpath);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int umask(int mask) {
        return this.posix.umask(mask);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int unsetenv(String envName) {
        return this.posix.unsetenv(envName);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int utimes(String path, Pointer times) {
        return this.posix.utimes(path, times);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int waitpid(int pid, int[] status, int flags) {
        return this.posix.waitpid(pid, status, flags);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int waitpid(long pid, int[] status, int flags) {
        return this.posix.waitpid(pid, status, flags);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int wait(int[] status) {
        return this.posix.wait(status);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int errno() {
        return this.posix.errno();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void errno(int value) {
        this.posix.errno(value);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int chdir(String path) {
        return this.posix.chdir(path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long sysconf(Sysconf name) {
        return this.posix.sysconf(name);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Times times() {
        return this.posix.times();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int posix_spawnp(String path, Collection<? extends SpawnFileAction> fileActions, Collection<? extends CharSequence> argv, Collection<? extends CharSequence> envp) {
        long pid = this.posix.posix_spawnp(path, fileActions, argv, envp);
        if (Platform.getPlatform().getOS() == Platform.OS.SOLARIS) {
            return (int)(pid >> 32);
        }
        return CoreLibrary.long2int(pid);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int flock(int fd, int operation) {
        return this.posix.flock(fd, operation);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int dup(int fd) {
        return this.posix.dup(fd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int dup2(int oldFd, int newFd) {
        return this.posix.dup2(oldFd, newFd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fcntlInt(int fd, Fcntl fcntlConst, int arg) {
        return this.posix.fcntlInt(fd, fcntlConst, arg);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fcntl(int fd, Fcntl fcntlConst) {
        return this.posix.fcntl(fd, fcntlConst);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int access(CharSequence path, int amode) {
        return this.posix.access(path, amode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int close(int fd) {
        return this.posix.close(fd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int unlink(CharSequence path) {
        return this.posix.unlink(path);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int open(CharSequence path, int flags, int perm) {
        return this.posix.open(path, flags, perm);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int write(int fd, byte[] buf, int n) {
        return this.posix.write(fd, buf, n);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int read(int fd, byte[] buf, int n) {
        return this.posix.read(fd, buf, n);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int write(int fd, ByteBuffer buf, int n) {
        return this.posix.write(fd, buf, n);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int read(int fd, ByteBuffer buf, int n) {
        return this.posix.read(fd, buf, n);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int lseek(int fd, long offset, int whence) {
        return this.posix.lseek(fd, offset, whence);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int pipe(int[] fds) {
        return this.posix.pipe(fds);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int truncate(CharSequence path, long length) {
        return this.posix.truncate(path, length);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int ftruncate(int fd, long offset) {
        return this.posix.ftruncate(fd, offset);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int rename(CharSequence oldName, CharSequence newName) {
        return this.posix.rename(oldName, newName);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getcwd() {
        return this.posix.getcwd();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int fsync(int fd) {
        return this.posix.fsync(fd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int isatty(int fd) {
        return this.posix.libc().isatty(fd);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int mkfifo(String path, int mode) {
        return this.posix.mkfifo(path, mode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public long[] getgroups() {
        return this.posix.getgroups();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String nl_langinfo(int item) {
        return this.posix.nl_langinfo(item);
    }
}

