var WebpackDevServer = require('webpack-dev-server'),
	webpack = require('webpack'),
	config = require('./dev.config'),
	host = process.env.HOST || 'localhost',
	port = parseInt(process.env.PORT) + 1 || 3001,
	serverOptions = {
		contentBase: config.ocRoot + '/' + config.appId + '/',
		quiet: true,
		noInfo: true,
		hot: true,
		inline: true,
		lazy: false,
		publicPath: config.output.publicPath,
		headers: {"Access-Control-Allow-Origin": "*"},
		stats: {colors: true}
	},
	compiler = webpack(config, function (err, stats) {
		var json = stats.toJson();
		if (json.errors.length)
			console.error(json.errors[0])
	}),
	webpackDevServer = new WebpackDevServer(compiler, serverOptions);

webpackDevServer.listen(port, host, function () {
	console.info('==> 🚧  Webpack development server listening on %s:%s', host, port);
});
