/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.beanshell;

import com.sun.star.script.framework.provider.beanshell.GlyphGutter;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceModel;
import com.sun.star.script.framework.provider.beanshell.ScriptSourceView;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class PlainSourceView
extends JScrollPane
implements ScriptSourceView,
DocumentListener {
    private final ScriptSourceModel model;
    private JTextArea ta;
    private GlyphGutter gg;
    private int linecount;
    private boolean isModified = false;
    private static final String undoKey = "Undo";
    private static final String redoKey = "Redo";
    private CompoundEdit compoundEdit = null;
    private static final int noLimit = -1;
    UndoManager undoManager;

    public PlainSourceView(ScriptSourceModel model) {
        this.model = model;
        this.initUI();
        model.setView(this);
    }

    public void undo() {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
            this.undoManager.addEdit(this.compoundEdit);
            this.compoundEdit = null;
        }
        if (this.undoManager.canUndo()) {
            this.undoManager.undo();
        }
    }

    public void redo() {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void clear() {
        this.ta.setText("");
    }

    public void update() {
        this.ta.getDocument().removeDocumentListener(this);
        if (!this.isModified) {
            int pos = this.ta.getCaretPosition();
            this.ta.setText(this.model.getText());
            try {
                this.ta.setCaretPosition(pos);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            int line = this.ta.getLineStartOffset(this.model.getCurrentPosition());
            Rectangle rect = this.ta.modelToView(line);
            if (rect != null) {
                this.ta.scrollRectToVisible(rect);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.gg.repaint();
        this.ta.getDocument().addDocumentListener(this);
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean value) {
        this.isModified = value;
    }

    private void initUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ta = new JTextArea();
        this.ta.setTabSize(4);
        this.ta.setRows(15);
        this.ta.setColumns(40);
        this.ta.setLineWrap(false);
        this.ta.insert(this.model.getText(), 0);
        this.ta.setFont(new Font("Monospaced", this.ta.getFont().getStyle(), this.ta.getFont().getSize()));
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(-1);
        this.ta.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent editEvent) {
                if (PlainSourceView.this.compoundEdit == null) {
                    PlainSourceView.this.compoundEdit = new CompoundEdit();
                }
                PlainSourceView.this.compoundEdit.addEdit(editEvent.getEdit());
            }
        });
        this.ta.getInputMap().put(KeyStroke.getKeyStroke(90, 2), undoKey);
        this.ta.getInputMap().put(KeyStroke.getKeyStroke(89, 2), redoKey);
        this.ta.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 32 || ke.getKeyCode() == 10) {
                    PlainSourceView.this.compoundEdit.end();
                    PlainSourceView.this.undoManager.addEdit(PlainSourceView.this.compoundEdit);
                    PlainSourceView.this.compoundEdit = null;
                }
            }
        });
        this.ta.getActionMap().put(undoKey, new AbstractAction(undoKey){

            public void actionPerformed(ActionEvent event) {
                PlainSourceView.this.undo();
            }
        });
        this.ta.getActionMap().put(redoKey, new AbstractAction(redoKey){

            public void actionPerformed(ActionEvent event) {
                PlainSourceView.this.redo();
            }
        });
        this.linecount = this.ta.getLineCount();
        this.gg = new GlyphGutter(this);
        this.setViewportView(this.ta);
        this.setRowHeaderView(this.gg);
        this.ta.getDocument().addDocumentListener(this);
    }

    public void insertUpdate(DocumentEvent e) {
        this.doChanged();
    }

    public void removeUpdate(DocumentEvent e) {
        this.doChanged();
    }

    public void changedUpdate(DocumentEvent e) {
        this.doChanged();
    }

    private void doChanged() {
        this.isModified = true;
        if (this.linecount != this.ta.getLineCount()) {
            this.gg.update();
            this.linecount = this.ta.getLineCount();
        }
    }

    public String getText() {
        return this.ta.getText();
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public int getCurrentPosition() {
        return this.model.getCurrentPosition();
    }
}

