/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.feed.DefaultInputFeed;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.normalizer.ChainingNormalizer;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.normalizer.displaymodel.ModelBuilder;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.renderer.ChainingRenderer;
import org.jfree.layouting.renderer.Renderer;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class ChainingOutputProcessor
implements OutputProcessor {
    private OutputProcessor outputProcessor;

    public ChainingOutputProcessor(OutputProcessor outputProcessor) {
        this.outputProcessor = outputProcessor;
    }

    public InputFeed createInputFeed(LayoutProcess layoutProcess) {
        return new DefaultInputFeed(layoutProcess);
    }

    public OutputProcessorMetaData getMetaData() {
        return this.outputProcessor.getMetaData();
    }

    public Normalizer createNormalizer(LayoutProcess layoutProcess) {
        return new ChainingNormalizer(this.outputProcessor.createNormalizer(layoutProcess));
    }

    public ModelBuilder createModelBuilder(LayoutProcess layoutProcess) {
        return this.outputProcessor.createModelBuilder(layoutProcess);
    }

    public Renderer createRenderer(LayoutProcess layoutProcess) {
        return new ChainingRenderer(this.outputProcessor.createRenderer(layoutProcess));
    }

    public void processContent(LogicalPageBox logicalPageBox) {
        this.outputProcessor.processContent(logicalPageBox);
    }

    public void processingFinished() {
        this.outputProcessor.processingFinished();
    }

    public boolean isGlobalStateComputed() {
        return this.outputProcessor.isGlobalStateComputed();
    }

    public boolean isContentGeneratable() {
        return this.outputProcessor.isContentGeneratable();
    }

    public Configuration getConfiguration() {
        return this.outputProcessor.getConfiguration();
    }

    public int getLogicalPageCount() {
        return this.outputProcessor.getLogicalPageCount();
    }

    public LogicalPageKey getLogicalPage(int n) {
        return this.outputProcessor.getLogicalPage(n);
    }

    public void setPageCursor(int n) {
        this.outputProcessor.setPageCursor(n);
    }

    public int getPageCursor() {
        return this.outputProcessor.getPageCursor();
    }

    public boolean isPaginationFinished() {
        return this.outputProcessor.isPaginationFinished();
    }

    public void processDocumentMetaData(DocumentContext documentContext) {
        this.outputProcessor.processDocumentMetaData(documentContext);
    }
}

