/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.I18n;

public class PlayHeadDragMode
extends MapMode {
    private boolean dragging;
    private Point mousePos;
    private Point mouseStart;
    private final transient PlayHeadMarker playHeadMarker;

    public PlayHeadDragMode(PlayHeadMarker playHeadMarker) {
        super(I18n.tr("Drag play head", new Object[0]), "playheaddrag", I18n.tr("Drag play head", new Object[0]), null, Main.map, Cursor.getPredefinedCursor(13));
        this.playHeadMarker = playHeadMarker;
    }

    @Override
    public void enterMode() {
        super.enterMode();
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseStart = this.mousePos = mouseEvent.getPoint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mouseStart == null || this.mousePos == null) {
            return;
        }
        if ((mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        Point point = mouseEvent.getPoint();
        if (!this.dragging) {
            if (point.distance(this.mouseStart) < 3.0) {
                return;
            }
            this.playHeadMarker.startDrag();
            this.dragging = true;
        }
        if (point.distance(this.mousePos) == 0.0) {
            return;
        }
        this.playHeadMarker.drag(Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY()));
        this.mousePos = point;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseStart = null;
        if (mouseEvent.getButton() != 1 || !this.dragging) {
            return;
        }
        this.requestFocusInMapView();
        this.updateKeyModifiers(mouseEvent);
        EastNorth eastNorth = Main.map.mapView.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        if (!this.shift) {
            this.playHeadMarker.reposition(eastNorth);
        } else {
            this.playHeadMarker.synchronize(eastNorth);
        }
        this.mousePos = null;
        this.dragging = false;
    }

    @Override
    public String getModeHelpText() {
        return I18n.tr("Drag play head and release near track to play audio from there; SHIFT+release to synchronize audio at that point.", new Object[0]);
    }
}

