/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.openide.util.lookup.implspi.ServiceLoaderLine;

public abstract class AbstractServiceProviderProcessor
extends AbstractProcessor {
    private final Map<Filer, Map<String, SortedSet<ServiceLoaderLine>>> outputFilesByProcessor = new WeakHashMap<Filer, Map<String, SortedSet<ServiceLoaderLine>>>();
    private final Map<Filer, Map<String, List<Element>>> originatingElementsByProcessor = new WeakHashMap<Filer, Map<String, List<Element>>>();
    private final Map<TypeElement, Boolean> verifiedClasses = new WeakHashMap<TypeElement, Boolean>();

    protected AbstractServiceProviderProcessor() {
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.ServiceProviderProcessor")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.URLStreamHandlerRegistrationProcessor")) {
            return;
        }
        if (this.getClass().getName().equals("org.netbeans.modules.openide.util.NamedServiceProcessor")) {
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.errorRaised()) {
            return false;
        }
        if (roundEnvironment.processingOver()) {
            this.writeServices();
            this.outputFilesByProcessor.clear();
            this.originatingElementsByProcessor.clear();
            return true;
        }
        return this.handleProcess(set, roundEnvironment);
    }

    protected abstract boolean handleProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    protected final void register(Element element, Class<? extends Annotation> clazz, TypeMirror typeMirror, String string, int n, String ... stringArray) {
        if (element.getKind() != ElementKind.CLASS) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, clazz.getName() + " is not applicable to a " + (Object)((Object)element.getKind()), element);
            return;
        }
        if (element.getEnclosingElement().getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Inner class needs to be static to be annotated with @ServiceProvider", element);
            return;
        }
        TypeElement typeElement = (TypeElement)element;
        String string2 = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
        String string3 = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror)).toString();
        if (!this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), typeMirror)) {
            AnnotationMirror annotationMirror = this.findAnnotationMirror(typeElement, clazz);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, string2 + " is not assignable to " + string3, typeElement, annotationMirror, this.findAnnotationValue(annotationMirror, "service"));
            return;
        }
        String string4 = (string.length() > 0 ? "META-INF/namedservices/" + string + "/" : "META-INF/services/") + string3;
        Boolean bl = this.verifiedClasses.get(typeElement);
        if (bl == null) {
            bl = this.verifyServiceProviderSignature(typeElement, clazz);
            this.verifiedClasses.put(typeElement, bl);
        }
        if (!bl.booleanValue()) {
            return;
        }
        this.registerImpl(typeElement, string2, string4, n, stringArray);
    }

    protected final void register(Element element, String string) {
        TypeElement typeElement = (TypeElement)element;
        String string2 = this.processingEnv.getElementUtils().getBinaryName(typeElement).toString();
        this.registerImpl(typeElement, string2, string, Integer.MAX_VALUE, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerImpl(TypeElement typeElement, String string, String string2, int n, String ... stringArray) {
        SequencedCollection<Element> sequencedCollection;
        Filer filer = this.processingEnv.getFiler();
        Map<String, SequencedCollection<Object>> map = this.originatingElementsByProcessor.get(filer);
        if (map == null) {
            map = new HashMap<String, List<Element>>();
            this.originatingElementsByProcessor.put(filer, map);
        }
        if ((sequencedCollection = map.get(string2)) == null) {
            sequencedCollection = new ArrayList<Element>();
            map.put(string2, sequencedCollection);
        }
        sequencedCollection.add(typeElement);
        map = this.outputFilesByProcessor.get(filer);
        if (map == null) {
            map = new HashMap();
            this.outputFilesByProcessor.put(filer, map);
        }
        if ((sequencedCollection = (SortedSet)map.get(string2)) == null) {
            sequencedCollection = new TreeSet();
            try {
                try {
                    FileObject fileObject = filer.getResource(StandardLocation.SOURCE_PATH, "", string2);
                    fileObject.openInputStream().close();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot generate " + string2 + " because it already exists in sources: " + fileObject.toUri());
                    return;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                try {
                    FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", string2);
                    InputStream inputStream = fileObject.openInputStream();
                    try {
                        ServiceLoaderLine.parse(new InputStreamReader(inputStream, "UTF-8"), sequencedCollection);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
            catch (IOException iOException) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, iOException.toString());
                return;
            }
            map.put(string2, sequencedCollection);
        }
        sequencedCollection.add((Element)((Object)new ServiceLoaderLine(string, n, stringArray)));
    }

    private AnnotationMirror findAnnotationMirror(Element element, Class<? extends Annotation> clazz) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getElementUtils().getBinaryName((TypeElement)annotationMirror.getAnnotationType().asElement()).contentEquals(clazz.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    private AnnotationValue findAnnotationValue(AnnotationMirror annotationMirror, String string) {
        if (annotationMirror != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().contentEquals(string)) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    private boolean verifyServiceProviderSignature(TypeElement typeElement, Class<? extends Annotation> clazz) {
        AnnotationMirror annotationMirror = this.findAnnotationMirror(typeElement, clazz);
        if (!typeElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must be public", typeElement, annotationMirror);
            return false;
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must not be abstract", typeElement, annotationMirror);
            return false;
        }
        if (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE && !typeElement.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must be static", typeElement, annotationMirror);
            return false;
        }
        boolean bl = false;
        for (ExecutableElement executableElement : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || !executableElement.getParameters().isEmpty()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, typeElement + " must have a public no-argument constructor", typeElement, annotationMirror);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeServices() {
        for (Map.Entry<Filer, Map<String, SortedSet<ServiceLoaderLine>>> entry : this.outputFilesByProcessor.entrySet()) {
            Filer filer = entry.getKey();
            for (Map.Entry<String, SortedSet<ServiceLoaderLine>> entry2 : entry.getValue().entrySet()) {
                try {
                    FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", entry2.getKey(), this.originatingElementsByProcessor.get(filer).get(entry2.getKey()).toArray(new Element[0]));
                    OutputStream outputStream = fileObject.openOutputStream();
                    try {
                        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                        for (ServiceLoaderLine serviceLoaderLine : entry2.getValue()) {
                            serviceLoaderLine.write(printWriter);
                        }
                        printWriter.flush();
                        printWriter.close();
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write to " + entry2.getKey() + ": " + iOException.toString());
                }
            }
        }
    }

    @Deprecated
    protected final void register(TypeElement typeElement, Class<? extends Annotation> clazz, TypeMirror typeMirror, String string, int n, String[] stringArray) {
        this.register((Element)typeElement, clazz, typeMirror, string, n, stringArray);
    }
}

