/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.daemon;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.process.internal.daemon.WorkSpec;
import org.gradle.process.internal.daemon.WorkerDaemonAction;
import org.gradle.process.internal.daemon.WorkerDaemonProtocol;
import org.gradle.process.internal.daemon.WorkerDaemonResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDaemonServer
implements WorkerDaemonProtocol {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonServer.class);

    @Override
    public <T extends WorkSpec> WorkerDaemonResult execute(WorkerDaemonAction<T> action, T spec) {
        try {
            LOGGER.info("Executing {} in worker daemon.", (Object)action.getDescription());
            WorkerDaemonResult result = action.execute(spec);
            LOGGER.info("Successfully executed {} in worker daemon.", (Object)action.getDescription());
            return result;
        }
        catch (Throwable t) {
            LOGGER.info("Exception executing {} in worker daemon: {}.", (Object)action.getDescription(), (Object)t);
            return new WorkerDaemonResult(true, t);
        }
    }
}

