/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.HashCode;
import org.gradle.api.internal.changedetection.state.IncrementalFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.caching.internal.BuildCacheKeyBuilder;
import org.gradle.internal.hash.HashUtil;

public abstract class AbstractNormalizedFileSnapshot
implements NormalizedFileSnapshot {
    private final IncrementalFileSnapshot snapshot;

    public AbstractNormalizedFileSnapshot(IncrementalFileSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public IncrementalFileSnapshot getSnapshot() {
        return this.snapshot;
    }

    public void appendToCacheKey(BuildCacheKeyBuilder hasher) {
        hasher.putString(this.getNormalizedPath());
        hasher.putBytes(this.getSnapshot().getHash().asBytes());
    }

    public int compareTo(NormalizedFileSnapshot o) {
        int result = this.getNormalizedPath().compareTo(o.getNormalizedPath());
        if (result == 0) {
            result = HashUtil.compareHashCodes((HashCode)this.getSnapshot().getHash(), (HashCode)o.getSnapshot().getHash());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNormalizedFileSnapshot that = (AbstractNormalizedFileSnapshot)o;
        return this.snapshot.equals(that.snapshot) && this.getNormalizedPath().equals(that.getNormalizedPath());
    }

    public int hashCode() {
        int result = this.snapshot.hashCode();
        result = 31 * result + this.getNormalizedPath().hashCode();
        return result;
    }

    public String toString() {
        return String.format("'%s' / %s", this.getNormalizedPath(), this.snapshot);
    }
}

