/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationUtils;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.OrderSensitive;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInputPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    AbstractInputPropertyAnnotationHandler() {
    }

    @Override
    public void attachActions(final TaskPropertyActionContext context) {
        context.setValidationAction(new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, Collection<String> messages) {
                AbstractInputPropertyAnnotationHandler.this.validate(propertyName, value, messages);
            }
        });
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(TaskInternal task, Callable<Object> futureValue) {
                TaskInputFilePropertyBuilder propertyBuilder = AbstractInputPropertyAnnotationHandler.this.createPropertyBuilder(context, task, futureValue);
                propertyBuilder.withPropertyName(context.getName()).withPathSensitivity(PropertyAnnotationUtils.getPathSensitivity(context)).skipWhenEmpty(context.isAnnotationPresent(SkipWhenEmpty.class)).optional(context.isOptional());
                AbstractInputPropertyAnnotationHandler.this.handleOrderSensitive(propertyBuilder, context);
            }
        });
    }

    private void handleOrderSensitive(final TaskInputFilePropertyBuilder propertyBuilder, TaskPropertyActionContext context) {
        if (context.isAnnotationPresent(OrderSensitive.class)) {
            DeprecationLogger.nagUserOfDeprecated((String)"The @OrderSensitive annotation", (String)"For classpath properties, use the @Classpath annotation instead");
            DeprecationLogger.whileDisabled((Runnable)new Runnable(){

                public void run() {
                    propertyBuilder.orderSensitive();
                }
            });
        }
    }

    protected abstract TaskInputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext var1, TaskInternal var2, Callable<Object> var3);

    protected abstract void validate(String var1, Object var2, Collection<String> var3);
}

